import factory

from kelvin.lessons.models import Lesson, LessonProblemLink


class LessonFactory(factory.DjangoModelFactory):
    owner = factory.SubFactory("kelvin.accounts.factories.UserFactory")

    class Meta:
        model = Lesson


class LessonProblemLinkFactory(factory.DjangoModelFactory):
    lesson = factory.SubFactory(LessonFactory)
    problem = factory.SubFactory("kelvin.problems.factories.ProblemFactory")
    order = factory.Sequence(lambda n: n)

    class Meta:
        model = LessonProblemLink
