from django.db import migrations, models
import jsonfield.fields
from django.conf import settings
import sortedm2m.fields


class Migration(migrations.Migration):

    dependencies = [
        ('subjects', '0001_initial'),
        ('problems', '0001_initial'),
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
        ('resources', '0001_initial'),
    ]

    operations = [
        migrations.CreateModel(
            name='Lesson',
            fields=[
                ('id', models.AutoField(verbose_name='ID', serialize=False, auto_created=True, primary_key=True)),
                ('date_created', models.DateTimeField(auto_now_add=True, verbose_name='Creation date')),
                ('date_updated', models.DateTimeField(auto_now=True, verbose_name='Date of change')),
                ('name', models.CharField(default='', max_length=255, verbose_name='\u041d\u0430\u0437\u0432\u0430\u043d\u0438\u0435 \u0443\u0447\u0435\u0431\u043d\u043e\u0433\u043e \u0437\u0430\u043d\u044f\u0442\u0438\u044f')),
                ('edu_id', models.CharField(null=True, default=None, max_length=255, blank=True, unique=True, verbose_name='\u0418\u0434\u0435\u043d\u0442\u0438\u0444\u0438\u043a\u0430\u0442\u043e\u0440 \u0423\u0447\u0435\u0431\u044b')),
                ('cover', models.ForeignKey(related_name='cover_for_lessons', verbose_name='\u041e\u0431\u043b\u043e\u0436\u043a\u0430', blank=True, to='resources.Resource', null=True)),
                ('methodology', sortedm2m.fields.SortedManyToManyField(help_text=None, to='resources.Resource', verbose_name='\u0424\u0430\u0439\u043b\u044b \u043c\u0435\u0442\u043e\u0434\u0438\u043a\u0438', blank=True)),
                ('owner', models.ForeignKey(verbose_name='\u0410\u0432\u0442\u043e\u0440 \u0437\u0430\u043d\u044f\u0442\u0438\u044f', to=settings.AUTH_USER_MODEL)),
            ],
            options={
                'verbose_name': '\u0423\u0447\u0435\u0431\u043d\u043e\u0435 \u0437\u0430\u043d\u044f\u0442\u0438\u0435',
                'verbose_name_plural': '\u0423\u0447\u0435\u0431\u043d\u044b\u0435 \u0437\u0430\u043d\u044f\u0442\u0438\u044f',
            },
        ),
        migrations.CreateModel(
            name='LessonProblemLink',
            fields=[
                ('id', models.AutoField(verbose_name='ID', serialize=False, auto_created=True, primary_key=True)),
                ('type', models.IntegerField(default=1, verbose_name='\u0422\u0438\u043f \u0437\u0430\u0434\u0430\u0447\u0438', choices=[(1, '\u041e\u0431\u044b\u0447\u043d\u0430\u044f \u0437\u0430\u0434\u0430\u0447\u0430'), (3, '\u0422\u0435\u043e\u0440\u0438\u044f')])),
                ('order', models.PositiveIntegerField(verbose_name='\u041f\u043e\u0440\u044f\u0434\u043a\u043e\u0432\u044b\u0439 \u043d\u043e\u043c\u0435\u0440 \u0432 \u0437\u0430\u043d\u044f\u0442\u0438\u0438')),
                ('options', jsonfield.fields.JSONField(null=True, verbose_name='\u0421\u0432\u043e\u0439\u0441\u0442\u0432\u0430 \u0432\u043e\u043f\u0440\u043e\u0441\u0430', blank=True)),
                ('cm_order', models.CharField(default='', max_length=32, verbose_name='\u041f\u043e\u0440\u044f\u0434\u043e\u043a \u0437\u0430\u0434\u0430\u0447 \u0443 \u043a\u043e\u043d\u0442\u0435\u043d\u0442-\u043c\u0435\u043d\u0435\u0434\u0436\u0435\u0440\u0430', blank=True)),
                ('lesson', models.ForeignKey(verbose_name='\u0417\u0430\u043d\u044f\u0442\u0438\u0435', to='lessons.Lesson')),
                ('problem', models.ForeignKey(verbose_name='\u0412\u043e\u043f\u0440\u043e\u0441', blank=True, to='problems.Problem', null=True)),
                ('theory', models.ForeignKey(verbose_name='\u0422\u0435\u043e\u0440\u0438\u044f', blank=True, to='problems.TextResource', null=True)),
            ],
            options={
                'ordering': ['order'],
                'verbose_name': '\u0421\u0446\u0435\u043d\u0430\u0440\u0438\u0439 \u0432\u043e\u043f\u0440\u043e\u0441\u0430 \u0432 \u0437\u0430\u043d\u044f\u0442\u0438\u0438',
                'verbose_name_plural': '\u0421\u0446\u0435\u043d\u0430\u0440\u0438\u0438 \u0432\u043e\u043f\u0440\u043e\u0441\u043e\u0432 \u0432 \u0437\u0430\u043d\u044f\u0442\u0438\u0438',
            },
        ),
        migrations.CreateModel(
            name='LessonScenario',
            fields=[
                ('id', models.AutoField(verbose_name='ID', serialize=False, auto_created=True, primary_key=True)),
                ('mode', models.IntegerField(default=1, verbose_name='\u0420\u0435\u0436\u0438\u043c \u0437\u0430\u043d\u044f\u0442\u0438\u044f', choices=[(1, '\u0422\u0440\u0435\u043d\u0438\u0440\u043e\u0432\u043a\u0430'), (2, '\u041a\u043e\u043d\u0442\u0440\u043e\u043b\u044c\u043d\u0430\u044f \u0440\u0430\u0431\u043e\u0442\u0430'), (3, '\u0412\u0435\u0431\u0438\u043d\u0430\u0440'), (4, '\u0414\u0438\u0430\u0433\u043d\u043e\u0441\u0442\u0438\u043a\u0430')])),
                ('duration', models.IntegerField(null=True, verbose_name='\u0414\u043b\u0438\u0442\u0435\u043b\u044c\u043d\u043e\u0441\u0442\u044c \u0437\u0430\u043d\u044f\u0442\u0438\u044f (\u043c\u0438\u043d\u0443\u0442\u044b)', blank=True)),
                ('finish_date', models.DateTimeField(null=True, verbose_name='\u0412\u0440\u0435\u043c\u044f \u043e\u043a\u043e\u043d\u0447\u0430\u043d\u0438\u044f \u043a\u043e\u043d\u0442\u0440\u043e\u043b\u044c\u043d\u043e\u0439 \u0438\u043b\u0438 \u0434\u0438\u0430\u0433\u043d\u043e\u0441\u0442\u0438\u043a\u0438', blank=True)),
                ('evaluation_date', models.DateTimeField(null=True, verbose_name='\u0412\u0440\u0435\u043c\u044f \u043f\u0443\u0431\u043b\u0438\u043a\u0430\u0446\u0438\u0438 \u0440\u0435\u0437\u0443\u043b\u044c\u0442\u0430\u0442\u043e\u0432 \u043a\u043e\u043d\u0442\u0440\u043e\u043b\u044c\u043d\u043e\u0439 \u0438\u043b\u0438 \u0434\u0438\u0430\u0433\u043d\u043e\u0441\u0442\u0438\u043a\u0438', blank=True)),
                ('max_attempts_in_group', models.IntegerField(default=2, verbose_name='\u041a\u043e\u043b\u0438\u0447\u0435\u0441\u0442\u0432\u043e \u0432\u043e\u0437\u043c\u043e\u0436\u043d\u044b\u0445 \u043f\u043e\u043f\u044b\u0442\u043e\u043a "\u0432 \u0433\u0440\u0443\u043f\u043f\u0435"')),
                ('show_answers_in_last_attempt', models.BooleanField(default=True, verbose_name='\u041f\u043e\u043a\u0430\u0437\u044b\u0432\u0430\u0442\u044c \u0432\u0435\u0440\u043d\u044b\u0435 \u043e\u0442\u0432\u0435\u0442\u044b \u0432 \u043f\u043e\u0441\u043b\u0435\u0434\u043d\u0435\u0439 \u043f\u043e\u043f\u044b\u0442\u043a\u0435 "\u0433\u0440\u0443\u043f\u043f\u044b" \u043f\u043e\u043f\u044b\u0442\u043e\u043a')),
                ('show_all_problems', models.BooleanField(default=True, verbose_name='\u041f\u043e\u043a\u0430\u0437\u044b\u0432\u0430\u0442\u044c \u0441\u0440\u0430\u0437\u0443 \u0432\u0441\u0435 \u0437\u0430\u0434\u0430\u0447\u0438')),
                ('url', jsonfield.fields.JSONField(verbose_name='\u0410\u0434\u0440\u0435\u0441\u0430 \u0434\u043b\u044f \u0432\u0435\u0431\u0438\u043d\u0430\u0440\u0430', blank=True)),
                ('start_date', models.DateTimeField(null=True, verbose_name='\u0414\u0430\u0442\u0430 \u0438 \u0432\u0440\u0435\u043c\u044f \u043d\u0430\u0447\u0430\u043b\u0430 \u0442\u0440\u0430\u043d\u0441\u043b\u044f\u0446\u0438\u0438 \u0432\u0435\u0431\u0438\u043d\u0430\u0440\u0430', blank=True)),
                ('comment', models.TextField(verbose_name='\u041a\u043e\u043c\u043c\u0435\u043d\u0442\u0430\u0440\u0438\u0439 \u043a \u0432\u0435\u0431\u0438\u043d\u0430\u0440\u0443', blank=True)),
                ('primary', models.BooleanField(default=False, verbose_name='\u041e\u0441\u043d\u043e\u0432\u043d\u043e\u0439 \u0441\u0446\u0435\u043d\u0430\u0440\u0438\u0439')),
            ],
            options={
                'verbose_name': '\u0421\u0446\u0435\u043d\u0430\u0440\u0438\u0439 \u0437\u0430\u043d\u044f\u0442\u0438\u044f',
                'verbose_name_plural': '\u0421\u0446\u0435\u043d\u0430\u0440\u0438\u0438 \u0437\u0430\u043d\u044f\u0442\u0438\u0439',
            },
        ),
        migrations.CreateModel(
            name='TextTemplate',
            fields=[
                ('id', models.AutoField(verbose_name='ID', serialize=False, auto_created=True, primary_key=True)),
                ('name', models.CharField(max_length=255, verbose_name='\u041d\u0430\u0437\u0432\u0430\u043d\u0438\u0435 \u0448\u0430\u0431\u043b\u043e\u043d\u0430')),
                ('template', models.TextField(verbose_name='\u0428\u0430\u0431\u043b\u043e\u043d')),
            ],
            options={
                'verbose_name': '\u0428\u0430\u0431\u043b\u043e\u043d \u0442\u0435\u043a\u0441\u0442\u0430',
                'verbose_name_plural': '\u0428\u0430\u0431\u043b\u043e\u043d\u044b \u0442\u0435\u043a\u0441\u0442\u043e\u0432',
            },
        ),
        migrations.AddField(
            model_name='lessonscenario',
            name='diagnostics_text',
            field=models.ForeignKey(verbose_name='\u0428\u0430\u0431\u043b\u043e\u043d \u0442\u0435\u043a\u0441\u0442\u0430 \u0434\u043b\u044f \u0440\u0435\u0437\u0443\u043b\u044c\u0442\u0430\u0442\u043e\u0432 \u0434\u0438\u0430\u0433\u043d\u043e\u0441\u0442\u0438\u043a\u0438', blank=True, to='lessons.TextTemplate', null=True),
        ),
        migrations.AddField(
            model_name='lessonscenario',
            name='lesson',
            field=models.ForeignKey(verbose_name='\u0417\u0430\u043d\u044f\u0442\u0438\u0435', to='lessons.Lesson'),
        ),
        migrations.AddField(
            model_name='lesson',
            name='problems',
            field=models.ManyToManyField(to='problems.Problem', verbose_name='\u0417\u0430\u0434\u0430\u0447\u0438 \u0432 \u0437\u0430\u043d\u044f\u0442\u0438\u0438', through='lessons.LessonProblemLink', blank=True),
        ),
        migrations.AddField(
            model_name='lesson',
            name='subject',
            field=models.ForeignKey(verbose_name='\u0423\u0447\u0435\u0431\u043d\u044b\u0439 \u043f\u0440\u0435\u0434\u043c\u0435\u0442 \u0437\u0430\u0434\u0430\u0447\u0438', blank=True, to='subjects.Subject', null=True),
        ),
        migrations.AddField(
            model_name='lesson',
            name='theme',
            field=models.ForeignKey(verbose_name='\u0422\u0435\u043c\u0430', blank=True, to='subjects.Theme', null=True),
        ),
    ]
