from builtins import object

from rest_framework import serializers

from kelvin.common.serializer_mixins import DateUpdatedFieldMixin
from kelvin.subjects.serializers import ThemeShortSerializer

from ..models import Lesson


class LessonInCourseSerializer(DateUpdatedFieldMixin,
                               serializers.ModelSerializer):
    """
    Сериализатор данных занятия в таблице занятия
    """
    problems_count = serializers.SerializerMethodField()
    theme = ThemeShortSerializer(read_only=True)
    max_points = serializers.SerializerMethodField()

    def get_problems_count(self, obj):
        """
        Возвращает число привязанных к уроку задач
        """
        return obj.lessonproblemlink_set.count()

    def get_max_points(self, lesson):
        return lesson.get_max_points()

    class Meta(object):
        model = Lesson
        fields = (
            'id',
            'name',
            'problems_count',
            'theme',
            'max_points',
        )
