from builtins import object

from rest_framework import serializers

from ..models import LessonScenario


class BaseLessonScenarioSerializer(serializers.ModelSerializer):
    class Meta(object):
        model = LessonScenario
        fields = (
            'id',
            'mode',
            'duration',
            'show_answers_in_last_attempt',
            'url',
            'start_date',
            'visual_mode',
        )


class CorpLessonScenarioSerializer(BaseLessonScenarioSerializer):
    class Meta(BaseLessonScenarioSerializer.Meta):
        fields = BaseLessonScenarioSerializer.Meta.fields + (
            'max_attempts_in_group',
            'show_all_problems',
            'comment',
        )


class LessonScenarioSerializer(CorpLessonScenarioSerializer):
    pass
