from django.db import models
from django.dispatch import receiver

from kelvin.lessons.models import Lesson, LessonProblemLink

from .services import update_available_for_support_on_lesson, update_available_for_support_on_lesson_problem_link


@receiver(signal=models.signals.post_save, sender=Lesson)
def update_available_for_support_on_lesson_handler(sender, instance, **kwargs):
    update_available_for_support_on_lesson(instance)


@receiver(signal=models.signals.post_save, sender=LessonProblemLink)
def update_available_for_support_on_lesson_problem_link_handler(sender, instance, **kwargs):
    update_available_for_support_on_lesson_problem_link(instance)
