import json
import logging
from builtins import object

import requests

from django.conf import settings


class SenderEmailController(object):
    """
    Email Backend который для отправки сообщений дергает Рассылятор
    (sender.yandex-team.ru)
    """
    @staticmethod
    def send_messages(receivers, template_code, sync=True, **kwargs):
        """
        Дергает ручку рассылятора с транзакционными рассылками
        :param receivers: массив мейлов получателей рассылки
        :param template_code: идентификатор шаблона в рассыляторе
        :param sync: True - сообщения рассылаются в порядке
        общей очереди рассылятора, True - сразу и асинхронно
        :param kwargs: переменные шаблона транзакционного письма,
        задаются в самом рассыляторе
        :return: сколько сообщений удалось отправить
        """

        success_messages_counter = 0

        data = [
            ('args', json.dumps(kwargs)),
            ('async', not sync),
        ]

        for receiver in receivers:
            params = (
                ('to_email', receiver),
            )

            response = requests.post(
                '{0}{1}'.format(
                    settings.SENDER_HOST,
                    settings.SENDER_TRANSACTION_URL.format(template_code)
                ),
                params=params,
                data=data,
                auth=(settings.SENDER_EDUCATION_AUTHORIZATION_KEY, ''),
                verify=settings.VERIFY_SENDER_HOST,
            )

            if response.status_code == 200:
                success_messages_counter += 1
            else:
                logging.error(
                    'Error while sending mail. Sender response: {0}. '
                    'Receiver: {1}\n'
                    .format(response, receiver)
                )

        return success_messages_counter
