from django.contrib.auth import get_user_model
from django.shortcuts import get_object_or_404
from django.template.response import TemplateResponse

from rest_framework.decorators import api_view

User = get_user_model()

CONFIRMATION_PAGE_TEMPLATE = 'mail/views/unsubscribe/confirm_unsubscribe.html'
SUCCESS_PAGE_TEMPLATE = 'mail/views/unsubscribe/successfully_unsubscribed.html'


@api_view(http_method_names=['GET', 'POST'])
def unsubscribe_view(request, user_code, **kwargs):
    """
    При GET-запросе возвращает страницу подтверждения отписки пользователя
    При POST-запросе выставляет пользователю unsubscribed True
    """
    user = get_object_or_404(User, parent_code=user_code)
    if user.unsubscribed:
        return TemplateResponse(
            request, SUCCESS_PAGE_TEMPLATE)

    if request.method == 'GET':
        return TemplateResponse(
            request, CONFIRMATION_PAGE_TEMPLATE, {'user': user})
    else:
        # Здесь POST-запрос; другие не пропустит DRF
        user.unsubscribed = True
        user.save()
        return TemplateResponse(
            request, SUCCESS_PAGE_TEMPLATE)
