from django.db import models
from django.utils.encoding import python_2_unicode_compatible

from kelvin.courses.models import Course


@python_2_unicode_compatible
class CourseMailingList(models.Model):
    """
    Настройки списков рассылки для курсов.
    Интеграция с сервисом:
    https://wiki.yandex-team.ru/sender/
    """
    slug = models.CharField(
        verbose_name='Идентификатор списка рассылки',
        max_length=100,
        blank=True,
    )
    course = models.OneToOneField(
        Course,
        verbose_name='Курс',
        related_name='mailing_list',
        on_delete=models.CASCADE,
    )

    class Meta:
        verbose_name = 'Список рассылки для курсов'
        verbose_name_plural = 'Список рассылки для курсов'

    def __str__(self):
        return self.slug
