from django.contrib import admin

from kelvin.news.models import News, NewsCourseLink


class CourseInNewsInline(admin.TabularInline):
    """
    Инлайн для связи новостей и курсов
    """
    model = NewsCourseLink


class NewsAdmin(admin.ModelAdmin):
    """
    Админка новостей
    """
    list_display = (
        'title',
        'status',
        'owner',
        'publication_date',
    )
    list_filter = (
        'status',
    )
    raw_id_fields = (
        'owner',
    )
    inlines = (
        CourseInNewsInline,
    )


class NewsCourseLinkAdmin(admin.ModelAdmin):
    """
    Админка для связей Новость - Курс
    """
    list_display = (
        'news',
        'course',
    )


admin.site.register(News, NewsAdmin)
admin.site.register(NewsCourseLink, NewsCourseLinkAdmin)
