from django.db import migrations, models
from django.conf import settings


class Migration(migrations.Migration):

    dependencies = [
        ('courses', '0003_auto_20171027_1202'),
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
    ]

    operations = [
        migrations.CreateModel(
            name='News',
            fields=[
                ('id', models.AutoField(verbose_name='ID', serialize=False, auto_created=True, primary_key=True)),
                ('date_created', models.DateTimeField(auto_now_add=True, verbose_name='Creation date')),
                ('date_updated', models.DateTimeField(auto_now=True, verbose_name='Date of change')),
                ('title', models.CharField(max_length=512, verbose_name='\u0417\u0430\u0433\u043e\u043b\u043e\u0432\u043e\u043a \u043d\u043e\u0432\u043e\u0441\u0442\u0438')),
                ('summary', models.TextField(verbose_name='\u041a\u0440\u0430\u0442\u043a\u043e\u0435 \u043e\u043f\u0438\u0441\u0430\u043d\u0438\u0435 \u043d\u043e\u0432\u043e\u0441\u0442\u0438')),
                ('content', models.TextField(verbose_name='\u0421\u043e\u0434\u0435\u0440\u0436\u0430\u043d\u0438\u0435 \u043d\u043e\u0432\u043e\u0441\u0442\u0438 (markdown)')),
                ('status', models.SmallIntegerField(verbose_name='\u0421\u0442\u0430\u0442\u0443\u0441 \u043d\u043e\u0432\u043e\u0441\u0442\u0438', choices=[(0, b'\xd1\x87\xd0\xb5\xd1\x80\xd0\xbd\xd0\xbe\xd0\xb2\xd0\xb8\xd0\xba'), (1, b'\xd0\xbe\xd0\xbf\xd1\x83\xd0\xb1\xd0\xbb\xd0\xb8\xd0\xba\xd0\xbe\xd0\xb2\xd0\xb0\xd0\xbd')])),
            ],
            options={
                'verbose_name': '\u041d\u043e\u0432\u043e\u0441\u0442\u044c',
                'verbose_name_plural': '\u041d\u043e\u0432\u043e\u0441\u0442\u0438',
            },
        ),
        migrations.CreateModel(
            name='NewsCourseLink',
            fields=[
                ('id', models.AutoField(verbose_name='ID', serialize=False, auto_created=True, primary_key=True)),
                ('course', models.ForeignKey(verbose_name='\u041a\u0443\u0440\u0441', to='courses.Course')),
                ('news', models.ForeignKey(verbose_name='\u041d\u043e\u0432\u043e\u0441\u0442\u044c', to='news.News')),
            ],
            options={
                'verbose_name': '\u0421\u0432\u044f\u0437\u044c \u043d\u043e\u0432\u043e\u0441\u0442\u0438 \u0441 \u043a\u0443\u0440\u0441\u043e\u043c',
                'verbose_name_plural': '\u0421\u0432\u044f\u0437\u0438 \u043d\u043e\u0432\u043e\u0441\u0442\u0435\u0439 \u0441 \u043a\u0443\u0440\u0441\u0430\u043c\u0438',
            },
        ),
        migrations.AddField(
            model_name='news',
            name='courses',
            field=models.ManyToManyField(related_name='publications', verbose_name='\u041a\u0443\u0440\u0441\u044b, \u043a \u043a\u043e\u0442\u043e\u0440\u044b\u043c \u043f\u0440\u0438\u0432\u044f\u0437\u0430\u043d\u044b \u043d\u043e\u0432\u043e\u0441\u0442\u0438', to='courses.Course', through='news.NewsCourseLink', blank=True),
        ),
        migrations.AddField(
            model_name='news',
            name='owner',
            field=models.ForeignKey(verbose_name='\u0410\u0432\u0442\u043e\u0440 \u0437\u0430\u043d\u044f\u0442\u0438\u044f', to=settings.AUTH_USER_MODEL),
        ),
    ]
