"""
JSON-схемы для валидации данных.
"""
from builtins import object

import jsonschema

from django.core.exceptions import ValidationError
from django.utils.html import escape


class InfoFieldSchema(object):
    """
    Класс инкапсулирует логику валидации поля `info`
    """
    JSON_SCHEMA = {
        'type': 'object',
        'properties': {
            'category': {
                'type': 'string',
            },
            'link': {
                'type': 'object',
                'properties': {
                    'text': {
                        'type': 'string',
                    },
                    'href': {
                        'type': 'string',
                        'format': 'uri',
                    },
                },
                'required': ['text', 'href'],
                'additionalProperties': False,
            },
        },
        'additionalProperties': False,
    }
    # Выводим в подсказке в админке
    ADMIN_HINT = u"<pre>{}</pre>".format(escape("""
{
    "category": "<Категория новости>",
    "link": {
        "text": "<Текст ссылки>",
        "href": "<URI>"
    }
}
"""))


def info_schema_validator(data):
    try:
        jsonschema.validate(data, InfoFieldSchema.JSON_SCHEMA)
    except jsonschema.ValidationError as e:
        raise ValidationError(e.message)
