from rest_condition import Or

from rest_framework import viewsets

from kelvin.accounts.permissions import ObjectOwnerOrContentManager, ObjectReadOnly
from kelvin.news.filters import NewsFilter
from kelvin.news.models import News
from kelvin.news.serializers import NewsSerializer
from kelvin.sapi.pagination import SiriusApiPaginator


class NewsViewSet(viewsets.ModelViewSet):
    """Ручки для новостей."""
    serializer_class = NewsSerializer
    pagination_class = SiriusApiPaginator
    queryset = News.objects.order_by('id').all().prefetch_related('newscourselink_set')
    filter_class = NewsFilter
    permission_classes = (
        Or(
            ObjectReadOnly,
            ObjectOwnerOrContentManager,
        ),
    )
