from model_utils.models import TimeStampedModel

from django.db import models
from django.utils.translation import ugettext_lazy as _


class PlayerData(TimeStampedModel):
    vsid = models.CharField(verbose_name='vsid', max_length=255)
    video_id = models.CharField(verbose_name='video_id', max_length=255)
    uid = models.BigIntegerField(verbose_name=_('Яндекс UID пользователя'))
    course_lesson_id = models.IntegerField(verbose_name='course_lesson_id')
    lesson_problem_id = models.IntegerField(verbose_name='lesson_problem_id')

    def __str__(self):
        return f'PlayerData {self.vsid}'

    class Meta:
        verbose_name = _('Данные плеера')
        verbose_name_plural = _('Данные плеера')
