from django.http import QueryDict

from rest_framework.generics import CreateAPIView
from rest_framework.permissions import IsAuthenticated

from .models import PlayerData
from .serializers import PlayerDataSerializer


class PlayerDataViewSet(CreateAPIView):
    queryset = PlayerData.objects.all()
    serializer_class = PlayerDataSerializer
    permission_classes = [
        IsAuthenticated,
    ]

    def perform_create(self, serializer):
        serializer.save(uid=self.request.user.yauid)
