from builtins import map

from mptt.admin import MPTTModelAdmin

from django.contrib import admin
from django.utils.translation import ugettext_lazy as _

from kelvin.problem_meta.models import Exam, ProblemMeta, ProblemMetaExam, Skill


class ProblemMetaAdmin(admin.ModelAdmin):
    """
    Админка для метаинформации о задаче
    """
    list_display = (
        'difficulty',
        'tags',
        'get_group_levels',
        'get_skills',
        'main_theme',
        'get_additional_themes',
        'get_exams',
    )

    def get_manytomany_list(self, manytomany_field):
        """
        Возвращает html список значений из поля `manytomany_field`
        """
        if not manytomany_field:
            return ''
        return u'<ul><li>{0}</li></ul>'.format(
            u'</li><li>'.join(map(str, manytomany_field)))

    def get_group_levels(self, obj):
        return self.get_manytomany_list(obj.group_levels.all())
    get_group_levels.short_description = _(u'Уровни групп')
    get_group_levels.allow_tags = True

    def get_skills(self, obj):
        return self.get_manytomany_list(obj.skills.all())
    get_skills.short_description = _(u'Навыки')
    get_skills.allow_tags = True

    def get_additional_themes(self, obj):
        return self.get_manytomany_list(obj.additional_themes.all())
    get_additional_themes.short_description = _(u'Доп. темы')
    get_additional_themes.allow_tags = True

    def get_exams(self, obj):
        return self.get_manytomany_list(obj.exams.all())
    get_exams.short_description = _(u'Экзамены')
    get_exams.allow_tags = True


class ExamAdmin(admin.ModelAdmin):
    """
    Админка модели экзамена
    """
    list_display = (
        'name', 'year', 'level',
    )
    list_filter = ('year',)


class SkillAdmin(MPTTModelAdmin):
    """
    Админка для модели Навыки
    """
    list_filter = ('subject',)
    list_display = ('name', 'subject')
    mptt_indent_field = 'name'
    list_select_related = ('subject',)


admin.site.register(Skill, SkillAdmin)
admin.site.register(Exam, ExamAdmin)
admin.site.register(ProblemMeta, ProblemMetaAdmin)
