from django.db import migrations, models
import django.contrib.postgres.fields
import mptt.fields


class Migration(migrations.Migration):

    replaces = [('problem_meta', '0001_initial'), ('problem_meta', '0002_auto_20171016_2012'), ('problem_meta', '0003_delete_problemmetabook')]

    dependencies = [
        ('group_levels', '0001_initial'),
        ('subjects', '0001_initial'),
    ]

    operations = [
        migrations.CreateModel(
            name='Exam',
            fields=[
                ('id', models.AutoField(verbose_name='ID', serialize=False, auto_created=True, primary_key=True)),
                ('name', models.CharField(max_length=255, verbose_name='\u041d\u0430\u0437\u0432\u0430\u043d\u0438\u0435 \u044d\u043a\u0437\u0430\u043c\u0435\u043d\u0430')),
                ('year', models.IntegerField(verbose_name='\u0413\u043e\u0434')),
                ('level', models.IntegerField(default=3, verbose_name='\u0423\u0440\u043e\u0432\u0435\u043d\u044c \u044d\u043a\u0437\u0430\u043c\u0435\u043d\u0430', choices=[(1, '\u0411\u0430\u0437\u043e\u0432\u044b\u0439'), (2, '\u041f\u0440\u043e\u0444\u0438\u043b\u044c\u043d\u044b\u0439'), (3, '\u041e\u0442\u0441\u0443\u0442\u0441\u0442\u0432\u0443\u0435\u0442')])),
            ],
            options={
                'verbose_name': '\u042d\u043a\u0437\u0430\u043c\u0435\u043d',
                'verbose_name_plural': '\u042d\u043a\u0437\u0430\u043c\u0435\u043d\u044b',
            },
        ),
        migrations.CreateModel(
            name='ProblemMeta',
            fields=[
                ('id', models.AutoField(verbose_name='ID', serialize=False, auto_created=True, primary_key=True)),
                ('date_created', models.DateTimeField(auto_now_add=True, verbose_name='Creation date')),
                ('date_updated', models.DateTimeField(auto_now=True, verbose_name='Date of change')),
                ('difficulty', models.IntegerField(verbose_name='\u0421\u043b\u043e\u0436\u043d\u043e\u0441\u0442\u044c \u0437\u0430\u0434\u0430\u0447\u0438', choices=[(1, '\u041f\u0440\u043e\u0441\u0442\u043e\u0439'), (2, '\u0421\u0440\u0435\u0434\u043d\u0438\u0439'), (3, '\u0421\u043b\u043e\u0436\u043d\u044b\u0439')])),
                ('tags', django.contrib.postgres.fields.ArrayField(size=None, base_field=models.CharField(max_length=255), null=True, verbose_name='\u0422\u0435\u0433\u0438 \u0437\u0430\u0434\u0430\u0447\u0438', blank=True)),
                ('additional_themes', models.ManyToManyField(to='subjects.Theme', verbose_name='\u0414\u043e\u043f\u043e\u043b\u043d\u0438\u0442\u0435\u043b\u044c\u043d\u044b\u0435 \u0442\u0435\u043c\u044b', blank=True)),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='ProblemMetaExam',
            fields=[
                ('id', models.AutoField(verbose_name='ID', serialize=False, auto_created=True, primary_key=True)),
                ('number', models.CharField(max_length=255, verbose_name='\u041d\u043e\u043c\u0435\u0440 \u0432 \u044d\u043a\u0437\u0430\u043c\u0435\u043d\u0435')),
                ('exam', models.ForeignKey(verbose_name='\u042d\u043a\u0437\u0430\u043c\u0435\u043d', to='problem_meta.Exam')),
                ('problem_meta', models.ForeignKey(verbose_name='\u041c\u0435\u0442\u0430-\u0438\u043d\u0444\u043e\u0440\u043c\u0430\u0446\u0438\u044f \u0437\u0430\u0434\u0430\u0447\u0438', to='problem_meta.ProblemMeta')),
            ],
            options={
                'ordering': ('exam__id',),
                'verbose_name': '\u0421\u0432\u044f\u0437\u044c \u043c\u0435\u0442\u0430-\u0438\u043d\u0444\u043e\u0440\u043c\u0430\u0446\u0438\u0438 \u0438 \u044d\u043a\u0437\u0430\u043c\u0435\u043d\u0430',
                'verbose_name_plural': '\u0421\u0432\u044f\u0437\u044c \u043c\u0435\u0442\u0430-\u0438\u043d\u0444\u043e\u0440\u043c\u0430\u0446\u0438\u0438 \u0438 \u044d\u043a\u0437\u0430\u043c\u0435\u043d\u043e\u0432',
            },
        ),
        migrations.CreateModel(
            name='Skill',
            fields=[
                ('id', models.AutoField(verbose_name='ID', serialize=False, auto_created=True, primary_key=True)),
                ('name', models.CharField(max_length=255, verbose_name='\u041d\u0430\u0437\u0432\u0430\u043d\u0438\u0435')),
                ('lft', models.PositiveIntegerField(editable=False, db_index=True)),
                ('rght', models.PositiveIntegerField(editable=False, db_index=True)),
                ('tree_id', models.PositiveIntegerField(editable=False, db_index=True)),
                ('level', models.PositiveIntegerField(editable=False, db_index=True)),
                ('parent', mptt.fields.TreeForeignKey(related_name='children', blank=True, to='problem_meta.Skill', null=True)),
                ('subject', models.ForeignKey(to='subjects.Subject')),
            ],
            options={
                'verbose_name': '\u041d\u0430\u0432\u044b\u043a',
                'verbose_name_plural': '\u041d\u0430\u0432\u044b\u043a\u0438',
            },
        ),
        migrations.AddField(
            model_name='problemmeta',
            name='classes',
            field=models.ManyToManyField(to='group_levels.GroupLevel', verbose_name='\u041a\u043b\u0430\u0441\u0441\u044b', blank=True),
        ),
        migrations.AddField(
            model_name='problemmeta',
            name='exams',
            field=models.ManyToManyField(to='problem_meta.Exam', verbose_name='\u042d\u043a\u0437\u0430\u043c\u0435\u043d\u044b', through='problem_meta.ProblemMetaExam', blank=True),
        ),
        migrations.AddField(
            model_name='problemmeta',
            name='main_theme',
            field=models.ForeignKey(related_name='main_theme', verbose_name='\u041e\u0441\u043d\u043e\u0432\u043d\u0430\u044f \u0442\u0435\u043c\u0430', blank=True, to='subjects.Theme', null=True),
        ),
        migrations.AddField(
            model_name='problemmeta',
            name='skills',
            field=models.ManyToManyField(to='problem_meta.Skill', verbose_name='\u041d\u0430\u0432\u044b\u043a\u0438', blank=True),
        ),
        migrations.AlterUniqueTogether(
            name='problemmetaexam',
            unique_together=set([('exam', 'problem_meta')]),
        ),
    ]
