from rest_framework import mixins, viewsets
from rest_framework.permissions import SAFE_METHODS, IsAdminUser

from kelvin.problem_meta.models import Exam, ProblemMeta, Skill
from kelvin.problem_meta.serializers import ExamSerializer, ProblemMetaSerializer, SkillSerializer


class ProblemMetaViewSet(viewsets.ModelViewSet):
    """
    Получение, добавление, изменение и удаление метаинформации о задаче
    """
    serializer_class = ProblemMetaSerializer

    def get_queryset(self):
        queryset = ProblemMeta.objects.all()
        # делаем prefetch только для SAFE_METHODS иначе для put запросов будут
        # возвращаться старые данные
        return (queryset if self.request.method not in SAFE_METHODS else
                queryset.prefetch_related('additional_themes', 'main_theme',
                                          'skills', 'exams', 'group_levels'))


class ExamViewSet(mixins.ListModelMixin,
                  viewsets.GenericViewSet):
    """
    Вьюсет экзаменов. Пока только list.
    """
    queryset = Exam.objects.all()
    serializer_class = ExamSerializer


# TODO: удалить по окончании импорта из Учебы
class ExamEduImportViewSet(mixins.ListModelMixin,
                           mixins.CreateModelMixin,
                           viewsets.GenericViewSet):
    """
    Вьюсет экзаменов со списком и созданием для импорта. По правам ограничен
    суперпользователем
    """
    queryset = Exam.objects.all()
    serializer_class = ExamSerializer
    pagination_class = None
    permission_classes = [IsAdminUser]


class SkillListViewSet(mixins.ListModelMixin,
                       viewsets.GenericViewSet):
    """
    API для Навыков.
    пока только список
    """
    queryset = Skill.objects.all()
    serializer_class = SkillSerializer
    filter_fields = ('subject',)
