import json

from kelvin.resources.admin import file_preview_url


def get_big_resource_preview(problem_object):
    """
    Выводит превью наибольшего ресурса
    """
    resources = list(problem_object.resources.all())
    if resources:
        big_resource = resources[0]
        for resource in resources[1:]:
            if big_resource.image_width < resource.image_width:
                big_resource = resource
        return file_preview_url(big_resource.get_content_url())
    return ''


def get_short_text(problem_object):
    """
    Возвращает содержимое первого контейнера из разметки задачи
    """
    texts = []
    for item in problem_object.markup.get('layout', []):
        if item['kind'] == 'text':
            texts.append(item['content']['text'])
        elif (item['kind'] == 'marker' and
              'text' in item['content']['options']):
            texts.append(item['content']['options']['text'])
    return ('\n'.join(texts) if texts
            else json.dumps(problem_object.markup, ensure_ascii=False))
