import re

RESOURCE_RE = re.compile(r'\{resource:(?P<resource_id>\d+)\}')
FORMULA_RE = re.compile(r'\{formula:(?P<formula_id>\d+)\}')
MARKER_RE = re.compile(r'\{marker:(?P<marker_id>\d+)\}')
MARKER_TAG_RE = re.compile(r'(\{marker:\d+\})')
RESOURCE_FORMULA_RE = re.compile(r'\{(resource|formula):(\d+)\}')

# Маркеры для которых сейчас проверяются ресурсы
RESOURCE_VALIDATED_MARKER_TYPES = [
    'field',  # поиск ресурсов реализован в маркере
    'choice',  # поиск ресурсов реализован в маркере
    'matching',  # поиск ресурсов реализован в маркере
    'connectareas',  # поиск ресурсов реализован в маркере
    'colorimage',  # поиск ресурсов реализован в маркере
    'coloring',  # поиск ресурсов реализован в маркере
    'textandfile',  # поиск ресурсов реализован в маркере
    'inline-choice',  # поиск ресурсов реализован в маркере
    'comma',  # поиск ресурсов реализован в маркере
    'separator',  # поиск ресурсов реализован в маркере
    'dragimage',  # поиск ресурсов реализован в маркере
    'dragtable',  # поиск ресурсов реализован в маркере
    'chooseimage',  # поиск ресурсов реализован в маркере
    'inline',  # поиск ресурсов реализован в маркере
    'checker_coloring',
    'edit',
    'neighbours',
    'select',
    'coretangram',  # нет ресурсов в маркере
    'chopsticks',  # нет ресурсов в маркере
    'coretrainer',  # нет ресурсов в маркере
    'coreconnectareas',
    'coredragtables',
    'dragtables',
    'coreplaceimages',
    'placeimages',
    'corepuzzles',
    'coreconnectelements',
    'coregroupingelements',
    'corefindthesame',
    'coreformbuilder',
    'diff_extension',
    'macaroni',
    'wordparts',  # нет ресурсов в маркере
    'highlight',  # нет ресурсов в маркере
    'scorm',
    'review',
]

# Маркеры, образованные из старого типа `coreproblems`
COREPROBLEMS_MARKER_TYPES = [
    'checker_coloring',
    'edit',
    'neighbours',
    'select',
]

# Маркеры, поддерживаемые андроид-устройствами, для наполнения `old_markup`
ANDROID_MARKER_TYPES = {
    'checker_coloring',
    'chooseimage',
    'chopsticks',
    'colorimage',
    'connectareas',
    'coreconnectareas',
    'coreconnectelements',
    'coredragtables',
    'corefindthesame',
    'coreformbuilder',
    'coregroupingelements',
    'coreplaceimages',
    'corepuzzles',
    'coretangram',
    'coretrainer',
    'diff_extension',
    'dragimage',
    'dragtable',  # `DragTablesMarker`
    'dragtables',  # вариация coredragtables
    'edit',
    'inline',
    'neighbours',
    'placeimages',
    'select',
    'select_extension',
}

# Маркеры, поддерживаемые фронтендом (и бэкендом)
FRONTEND_MARKER_TYPES = {
    'field',
    'choice',
    'matching',
    'connectareas',
    'colorimage',
    'coloring',
    'highlight',
    'textandfile',
    'inline-choice',
    'comma',
    'separator',
    'dragimage',
    'dragtable',
    'chooseimage',
    'inline',
    'macaroni',
    'wordparts',
    'scorm',
    'review',
}

# Маркеры, поддерживаемые андроид-устройствами и не поддерживаемые бэкендом
ANDROID_ONLY_MARKER_TYPES = ANDROID_MARKER_TYPES - FRONTEND_MARKER_TYPES

# Маркеры, которые требуют проверки чеком
MARKERS_WITH_CHECKS = {
    'inline',
    'dragimage',
    'dragtable',
}

# Системы именования списков
NAMING_TYPES_COMMON = ['abc', 'abcLower', 'abcLocal',
                       'abcLocalLower', 'numbers']

# Типы блоков в разметке
LAYOUT_BLOCK_KIND_TEXT = 'text'
LAYOUT_BLOCK_KIND_MARKER = 'marker'

# Поля разметки, в которых могут быть ресурсы и формулы
MARKUP_FIELDS_WITH_LINKED_OBJECTS = [
    'solution',
    'public_solution',
    'cm_comment',
]

# блок разметки типа Текст
BLOCK_TEXT_SCHEMA = {
    'type': 'object',
    'properties': {
        'kind': {'type': 'string', 'enum': [LAYOUT_BLOCK_KIND_TEXT]},
        'content': {
            'type': 'object',
            'properties': {
                'text': {
                    'type': 'string',
                },
                'options': {
                    'type': 'object',
                    'properties': {
                        'float': {
                            'type': 'string',
                            'enum': ['left', 'right'],
                        },
                        'align': {
                            'type': 'string',
                            'enum': ['left', 'right', 'center', 'justify'],
                        },
                        'style': {
                            'type': 'string',
                            'enum': ['normal', 'big', 'answer']
                        },
                    },
                    'additionalProperties': False,
                },
            },
            'additionalProperties': False,
            'required': ['text', 'options'],
        },
    },
    'additionalProperties': False,
    'required': ['kind', 'content'],
}

# блок разметки типа маркер
BLOCK_MARKER_SCHEMA = {
    'type': 'object',
    'properties': {
        'kind': {'type': 'string', 'enum': [LAYOUT_BLOCK_KIND_MARKER]},
        'content': {
            'type': 'object',
            'properties': {
                'id': {
                    'type': 'number'
                },
                'type': {
                    'type': 'string',
                    'enum': list(FRONTEND_MARKER_TYPES
                                 .union(ANDROID_MARKER_TYPES))
                },
                'options': {
                    'type': 'object',
                },
            },
            'additionalProperties': False,
            'required': ['id', 'type', 'options'],
        },
    },
    'additionalProperties': False,
    'required': ['kind', 'content'],
}

# TODO что-нибудь типа предобработки этого словаря
COMMON_MARKUP_SCHEMA = {
    'type': 'object',
    'properties': {
        'layout': {
            'type': 'array',
            'items': {
                'type': 'object',
                'oneOf': [BLOCK_TEXT_SCHEMA, BLOCK_MARKER_SCHEMA],
            },
            'minItems': 0,
        },
        'answers': {
            'type': 'object',
            'patternProperties': {
                '\d+$': {
                    'type': ['null', 'string', 'array', 'object']
                },
            },
            'additionalProperties': False,
        },
        'checks': {
            'type': 'object',
            'patternProperties': {
                '\d+$': {},
            },
            'additionalProperties': False,
        },
        'formulas': {
            'type': 'object',
            'patternProperties': {
                '^\d+$': {
                    'type': 'object',
                    'properties': {
                        'code': {
                            'type': 'string',
                        },
                        'url': {
                            'type': 'string',
                        },
                        'style': {
                            'type': 'string',
                        },
                    },
                    'required': ['code'],
                    'additionalProperties': False,
                }
            },
            'additionalProperties': False,
        },
        'solution': {
            'type': 'string',
        },
        'public_solution': {
            'type': 'string',
        },
        'cm_comment': {
            'type': 'string',
        },
    },
    'additionalProperties': False,
    'required': ['layout', 'answers', 'checks'],
}
