from builtins import object

import django_filters

from kelvin.group_levels.models import GroupLevel
from kelvin.problems.models import Problem


class ProblemFilter(django_filters.FilterSet):
    """
    Фильтр для вопросов
    """
    group_levels = django_filters.ModelMultipleChoiceFilter(
        name='meta__group_levels', queryset=GroupLevel.objects.all())
    difficulty = django_filters.NumberFilter(field_name='meta__difficulty')
    markup = django_filters.CharFilter(field_name='markup', lookup_expr='icontains')

    class Meta(object):
        model = Problem
        fields = ['difficulty', 'group_levels', 'markup']
