from kelvin.problems.markers.base import BaseMarker
from kelvin.problems.markers.choice import ChoiceMarker
from kelvin.problems.markers.chooseimage import ChooseImageMarker
from kelvin.problems.markers.colorimage import ColorImageMarker
from kelvin.problems.markers.coloring import ColoringMarker
from kelvin.problems.markers.connectareas import ConnectareasMarker
from kelvin.problems.markers.dragimage import DragImagesMarker
from kelvin.problems.markers.dragtable import DragTablesMarker
from kelvin.problems.markers.highlight import HighlightMarker
from kelvin.problems.markers.inline import InlineMarker
from kelvin.problems.markers.macaroni import MacaroniMarker
from kelvin.problems.markers.matching import MatchingMarker
from kelvin.problems.markers.scorm import ScormMarker
from kelvin.problems.markers.textandfile import TextAndFileMarker
from kelvin.problems.markers.wordparts import WordPartsMarker

MARKERS = {
    'choice': ChoiceMarker,
    'chooseimage': ChooseImageMarker,
    'colorimage': ColorImageMarker,
    'coloring': ColoringMarker,
    'connectareas': ConnectareasMarker,
    'dragimage': DragImagesMarker,
    'dragtable': DragTablesMarker,
    'highlight': HighlightMarker,
    'inline': InlineMarker,
    'macaroni': MacaroniMarker,
    'matching': MatchingMarker,
    'scorm': ScormMarker,
    'textandfile': TextAndFileMarker,
    'wordparts': WordPartsMarker,
}


class MarkerException(Exception):
    pass


class MarkerTypeNotGivenException(MarkerException):
    pass


class Marker(BaseMarker):
    """
    Класс для инициализации маркеров
    """
    def __new__(cls, data, *args, **kwargs):
        """
        Если тип маркера известен, создает соответствующий маркер
        """
        marker_type = data.get('type')
        if not marker_type:
            raise MarkerTypeNotGivenException
        marker_cls = MARKERS.get(marker_type)
        if marker_cls:
            return marker_cls(data, *args, **kwargs)
        return super(Marker, cls).__new__(cls)

    @property
    def max_mistakes(self):
        """
        По умолчанию максимум 1 ошибка
        """
        return 1

    def check(self, user_answer):
        """
        Если ответ совпадает, возвращает 0 ошибок и статус `CORRECT`, иначе
        1 ошибку и статус `INCORRECT`
        """
        if self.is_skipped(user_answer):
            return self.SKIPPED, 1
        return ((self.CORRECT, 0) if self.answer == user_answer
                else (self.INCORRECT, 1))
