from kelvin.problems.markers import BaseMarker


class ColorImageMarker(BaseMarker):
    """
    Маркер раскраски
    """
    TYPE_NAME = 'colorimage'
    # TODO: более подробные схемы
    ANSWER_JSON_SCHEMA = {
        'type': 'object',
    }
    RIGHT_ANSWER_JSON_SCHEMA = ANSWER_JSON_SCHEMA
    JSON_SCHEMA_OPTIONS = {
        'type': 'object',
    }

    def check(self, user_answer):
        """
        Всегда возвращает правильный статус
        """
        # TODO: настоящая проверка
        return self.CORRECT, 0

    @property
    def max_mistakes(self):
        """
        Максимум 1 ошибка
        """
        # TODO: настоящий подсчет ошибок
        return 1

    def get_embedded_objects(self):
        """
        Ищем ресурсы и формулы в полях `options.foreground`,
        `options.background`
        """
        options = self.data.get('options', {})
        return [
            ('resource', resource_id) for resource_id in
            (options.get('foreground'), options.get('background'))
            if resource_id is not None
        ]
