from kelvin.problems.markers import BaseMarker


class ColoringMarker(BaseMarker):
    """
    Маркер раскраски областей
    """
    TYPE_NAME = 'coloring'
    ANSWER_JSON_SCHEMA = {
        'oneOf': [
            {'enum': [BaseMarker.SKIPPED_ANSWER]},
            {
                'type': 'array',
                'items': {
                    'type': 'array',
                    'items': {
                        'type': 'string',
                    },
                },
            },
        ],
    }
    RIGHT_ANSWER_JSON_SCHEMA = ANSWER_JSON_SCHEMA
    JSON_SCHEMA_OPTIONS = {
        'type': 'object',
        'properties': {
            'init_coloring_image_views': {
                'type': 'object',
                'properties': {
                    'check_points_group': {
                        'type': 'array',
                        'items': {
                            'type': 'object',
                            'properties': {
                                'check_points': {
                                    'type': 'array',
                                    'items': {
                                        'type': 'object',
                                        'properties': {
                                            'x': {
                                                'type': 'number',
                                            },
                                            'y': {
                                                'type': 'number',
                                            },
                                        },
                                        'required': ['x', 'y'],
                                        'additionalProperties': False,
                                    },
                                },
                                'is_ordered': {
                                    'type': 'boolean',
                                },
                            },
                            'required': [
                                'check_points',
                                'is_ordered',
                            ],
                            'additionalProperties': False,
                        },
                    },
                    'height': {
                        'type': 'number',
                    },
                    'width': {
                        'type': 'number',
                    },
                    'x': {
                        'type': 'number',
                    },
                    'y': {
                        'type': 'number',
                    },
                    'background': {
                        'type': 'integer',
                    },
                },
                'required': [
                    'check_points_group',
                    'height',
                    'width',
                    'x',
                    'y',
                    'background',
                ],
                'additionalProperties': False,
            },
            'pallete_views': {
                'type': 'array',
                'items': {
                    'type': 'object',
                    'properties': {
                        'color': {
                            'type': 'string',
                        },
                        'color_symbol': {
                            'type': 'string',
                        },
                        'height': {
                            'type': 'number',
                        },
                        'width': {
                            'type': 'number',
                        },
                        'x': {
                            'type': 'number',
                        },
                        'y': {
                            'type': 'number',
                        },
                        'background': {
                            'type': 'integer',
                        },
                        'active_background': {
                            'type': 'integer',
                        },
                    },
                    'required': [
                        'color',
                        'color_symbol',
                        'height',
                        'width',
                        'x',
                        'y',
                        'background',
                        'active_background',
                    ],
                    'additionalProperties': False,
                },
            },
            'is_ordered': {
                'type': 'boolean',
            },
        },
        'required': [
            'init_coloring_image_views',
            'pallete_views',
            'is_ordered',
        ],
        'additionalProperties': False,
    }

    @property
    def max_mistakes(self):
        """
        Пока никак не считаем число ошибок, только правильно или неправильно
        """
        return 1

    def check(self, user_answer):
        """
        Проверяет ответ только на правильность/неправильность
        """
        if self.is_skipped(user_answer):
            return self.SKIPPED, 1

        if self.data['options']['is_ordered']:
            for i, group in enumerate(
                    self.data['options']['init_coloring_image_views']
                    ['check_points_group']):
                try:
                    if group['is_ordered']:
                        if self.answer[i] != user_answer[i]:
                            return self.INCORRECT, 1
                    else:
                        if set(self.answer[i]) != set(user_answer[i]):
                            return self.INCORRECT, 1
                except IndexError:
                    # в ответе пользователя меньше элементов, чем нужно
                    return self.INCORRECT, 1

        else:
            checked_answers = set()
            for i, group in enumerate(
                    self.data['options']['init_coloring_image_views']
                    ['check_points_group']):
                if group['is_ordered']:
                    for j, user_choice in enumerate(user_answer):
                        if (j not in checked_answers and
                                user_choice == self.answer[i]):
                            checked_answers.add(j)
                            break
                else:
                    for j, user_choice in enumerate(user_answer):
                        if (j not in checked_answers and set(user_choice) ==
                                set(self.answer[i])):
                            checked_answers.add(j)
                            break
            if (len(checked_answers) != len(user_answer) or
                    len(checked_answers) != len(self.answer)):
                return self.INCORRECT, 1
        return self.CORRECT, 0

    def get_embedded_objects(self):
        """
        Ресурсы указаны в полях `background`, `active_background`
        """
        resources = [
            self.data['options']['init_coloring_image_views']['background']]
        for item in self.data['options']['pallete_views']:
            resources.append(item['background'])
            resources.append(item['active_background'])
        return [('resource', resource_id) for resource_id in resources]
