from kelvin.problems.markers import BaseMarker


class ConnectareasMarker(BaseMarker):
    """
    Маркер соединения областей
    """
    TYPE_NAME = 'connectareas'
    # TODO дописать схему (элементы внутреннего списка)
    ANSWER_JSON_SCHEMA = {
        'oneOf': [
            {'enum': [BaseMarker.SKIPPED_ANSWER]},
            {
                'type': 'array',
                'items': {
                    'type': 'array',
                    'items': {
                        'type': 'object',
                    },
                    'minItems': 2,
                    'maxItems': 2,
                },
            },
        ],
    }
    RIGHT_ANSWER_JSON_SCHEMA = {
        'type': 'array',
        'items': ANSWER_JSON_SCHEMA,
    }
    JSON_SCHEMA_OPTIONS = {
        'type': 'object',
        'properties': {
            'color_map_file': {
                'type': 'integer',
            },
            'line_width': {
                'type': 'string',
            },
            'order_important': {
                'type': 'boolean',
            },
            'hit_areas': {
                'oneOf': [
                    {
                        'type': 'array',
                        'items': {
                            'type': 'array',
                            'minItems': 2,
                            'maxItems': 2,
                        },
                    },
                    {
                        'type': 'array',
                        'items': {
                            'type': 'object',
                            'properties': {
                                'x': {
                                    'type': 'number',
                                },
                                'y': {
                                    'type': 'number',
                                },
                                'width': {
                                    'type': 'number',
                                },
                                'height': {
                                    'type': 'number',
                                },
                                'id': {
                                    'type': 'string',
                                },
                            },
                        },
                    },
                ],
            },
            'image_file': {
                'type': 'integer',
            },
            'swap_enabled': {
                'type': 'boolean',
            },
        },
        'additionalProperties': False,
        'required': [
            'line_width',
            'order_important',
            'hit_areas',
            'image_file',
            'swap_enabled',
        ],
    }

    # TODO много констант в коде, надо их убрать
    @property
    def max_mistakes(self):
        """
        Пока никак не считаем число ошибок, только правильно или неправильно
        """
        return 1

    def _compare_answers(self, answer, right_answer, order_important):
        """
        Сравнение ответов
        """
        mistakes = 0
        status = []
        comparison_type = tuple if order_important else frozenset
        right_choices = set(
            comparison_type([item[0]['areaId'], item[1]['areaId']])
            for item in right_answer
        )
        for item in answer:
            choice = comparison_type([item[0]['areaId'], item[1]['areaId']])
            if choice in right_choices:
                status.append(self.CORRECT)
                right_choices.remove(choice)
            else:
                status.append(self.INCORRECT)
                mistakes += 1

        return status, mistakes + len(right_choices)

    def check(self, user_answer):
        """
        Проверяет на совпадение с одним из правильных вариантов ответа.

        В статусе пишет с каким вариантом ответа сравнивали и правильность
        ответа пользователя. При неправильном ответе возвращает вариант
        сравнения с наименьшими "ошибками".
        """
        if self.is_skipped(user_answer):
            return (
                # считаем, что сравнивали с первым ответом
                {'compared_with': 0, 'status': self.SKIPPED},
                1,
            )
        answer_statuses = []
        for compared_with, right_answer in enumerate(self.answer):
            answer_status, mistakes = self._compare_answers(
                user_answer,
                right_answer,
                self.data['options']['order_important'],
            )
            if not mistakes:
                return (
                    {
                        'compared_with': compared_with,
                        'status': answer_status,
                    },
                    0,
                )
            answer_statuses.append((answer_status, mistakes, compared_with))
        status = min(answer_statuses, key=lambda tuple_: tuple_[1])
        return (
            {
                'compared_with': status[2],
                'status': status[0],
            },
            1,
        )

    def get_embedded_objects(self):
        """
        Ресурсы указаны в полях `options.color_map_file` и `options.image_file`
        """
        options = self.data['options']
        resources = [
            ('resource', options['image_file']),
        ]
        if 'color_map_file' in options:
            resources.append(('resource', options['color_map_file']))

        return resources
