from kelvin.problems.checkers import DragChecker
from kelvin.problems.markers import DragImagesMarker


class DragTablesMarker(DragImagesMarker):
    """
    Маркер перетаскивания в таблице
    """
    TYPE_NAME = 'dragtable'
    ANSWER_JSON_SCHEMA = {
        'type': 'object',
        'patternProperties': {
            '^\d+$': {
                'type': 'integer',
            },
        },
        'additionalProperties': False,
    }
    RIGHT_ANSWER_JSON_SCHEMA = ANSWER_JSON_SCHEMA
    CHECKS_JSON_SCHEMA = {
        'check_definitions': DragChecker.definitions(),
        '$ref': '#/check_definitions/BOOL_VALUE_OPERATORS',
    }
    JSON_SCHEMA_OPTIONS = {
        'type': 'object',
        'properties': {
            'choices': {
                'type': 'array',
                'items': {
                    'type': 'object',
                    'properties': {
                        'id': {
                            'type': 'integer',
                        },
                        'image': {
                            'type': 'integer',
                        },
                        'value': {
                            'oneOf': [
                                {'type': 'integer'},
                                {'type': 'boolean'},
                            ],
                        },
                        'x': {
                            'type': 'number',
                        },
                        'y': {
                            'type': 'number',
                        },
                    },
                    'additionalProperties': False,
                    'required': ['id', 'value', 'image'],
                },
            },
            'multiple_choices': {
                'type': 'boolean',
            },
            'style': {
                'type': 'string',
            },
            'rows': {
                'type': 'array',
                'items': {
                    'type': 'object',
                    'properties': {
                        'header': {
                            'type': 'boolean',
                        },
                        'cells': {
                            'type': 'array',
                            'items': {
                                'type': 'object',
                                'properties': {
                                    'id': {
                                        'type': 'integer',
                                    },
                                    'header': {
                                        'type': 'boolean',
                                    },
                                    'colspan': {
                                        'type': 'integer',
                                    },
                                    'rowspan': {
                                        'type': 'integer',
                                    },
                                    'image': {
                                        'type': 'integer',
                                    },
                                    'text': {
                                        'type': 'string',
                                    },
                                    'choice': {
                                        'type': 'integer',
                                    },
                                    'disabled': {
                                        'type': 'boolean',
                                    },
                                },
                                'additionalProperties': False,
                            },
                        },
                    },
                    'additionalProperties': False,
                    'required': ['cells'],
                },
            },
        },
        'additionalProperties': False,
        'required': ['choices', 'multiple_choices', 'rows'],
    }

    # Этот пустой словарь необходим, потому что у
    # родительского класса словарь содержит данные
    JSON_SCHEMA_EXTRA = {}

    def get_embedded_objects(self):
        """
        Ресурсы маркера
        """
        resources = []
        for item in self.data['options']['choices']:
            resources.append(item['image'])
        for row in self.data['options']['rows']:
            for item in row['cells']:
                if 'image' in item:
                    resources.append(item['image'])
        return [('resource', resource_id) for resource_id in resources]
