from kelvin.problems.markers import BaseMarker


class ScormMarker(BaseMarker):
    """
    Scorm course marker. Stores only resource id of scorm package.
    """
    TYPE_NAME = 'scorm'

    ANSWER_JSON_SCHEMA = {
        'type': 'object',
    }
    RIGHT_ANSWER_JSON_SCHEMA = ANSWER_JSON_SCHEMA

    JSON_SCHEMA_OPTIONS = {
        'type': 'object',
        'properties': {
            'sco': {
                'type': 'object',
                'properties': {
                    'id': {
                        'type': 'integer',
                        'minimum': 1,
                    },
                },
                'required': ['id'],
                'additionalProperties': False,
            },
        },
        'additionalProperties': False,
        'required': ['sco'],
    }

    def check(self, user_answer):
        if self.answer != user_answer:
            return self.INCORRECT
        else:
            return self.CORRECT
