from kelvin.problems.markers import BaseMarker


class TextAndFileMarker(BaseMarker):
    """
    Маркер поля ввода и файла
    """
    TYPE_NAME = 'textandfile'
    ANSWER_JSON_SCHEMA = {
        'type': 'object',
        'properties': {
            'text': {
                'type': 'string',
            },
            'files': {
                'type': 'array',
                'items': {
                    'type': 'string',
                },
            },
        },
        'additionalProperties': False,
    }
    RIGHT_ANSWER_JSON_SCHEMA = ANSWER_JSON_SCHEMA
    JSON_SCHEMA_OPTIONS = {
        'type': 'object',
        'properties': {
            'hide_file': {
                'type': 'boolean',
            },
            'hide_textarea': {
                'type': 'boolean',
            },
        },
        'additionalProperties': False,
    }

    checkable = False

    def check(self, user_answer):
        """
        Не проверяем этот маркер
        """
        return self.UNCHECKED, None

    @property
    def max_mistakes(self):
        """
        Максимум 1 ошибка
        """
        return 1
