from django.db import migrations, models
import jsonfield.fields
from django.conf import settings
import kelvin.problems.models
import sortedm2m.fields


class Migration(migrations.Migration):

    dependencies = [
        ('subjects', '0001_initial'),
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
        ('resources', '0001_initial'),
        ('problem_meta', '0001_initial'),
    ]

    operations = [
        migrations.CreateModel(
            name='Problem',
            fields=[
                ('id', models.AutoField(verbose_name='ID', serialize=False, auto_created=True, primary_key=True)),
                ('date_created', models.DateTimeField(auto_now_add=True, verbose_name='Creation date')),
                ('date_updated', models.DateTimeField(auto_now=True, verbose_name='Date of change')),
                ('markup', jsonfield.fields.JSONField(
                    verbose_name='\u0420\u0430\u0437\u043c\u0435\u0442\u043a\u0430 \u0437\u0430\u0434\u0430\u0447\u0438')),
                ('old_markup', jsonfield.fields.JSONField(
                    null=True, verbose_name='\u0423\u0441\u0442\u0430\u0440\u0435\u0432\u0448\u0430\u044f \u0440\u0430\u0437\u043c\u0435\u0442\u043a\u0430 \u0437\u0430\u0434\u0430\u0447\u0438', blank=True)),
                ('converted', models.BooleanField(default=False,
                                                  verbose_name='\u0424\u043b\u0430\u0433 \u043a\u043e\u043d\u0432\u0435\u0440\u0442\u0438\u0440\u043e\u0432\u0430\u043d\u043d\u043e\u0441\u0442\u0438 \u0437\u0430\u0434\u0430\u0447\u0438')),
                ('name', models.CharField(max_length=255, null=True,
                                          verbose_name='\u041d\u0430\u0437\u0432\u0430\u043d\u0438\u0435 \u0437\u0430\u0434\u0430\u0447\u0438', blank=True)),
                ('visibility', models.IntegerField(default=1, verbose_name='\u0412\u0438\u0434\u0438\u043c\u043e\u0441\u0442\u044c', choices=[
                 (1, '\u0422\u043e\u043b\u044c\u043a\u043e \u043c\u043d\u0435'), (2, '\u0412\u0441\u0435\u043c')])),
                ('original', models.BooleanField(default=True, verbose_name='\u041e\u0440\u0438\u0433\u0438\u043d\u0430\u043b')),
                ('edu_id', models.CharField(max_length=255, unique=True, null=True,
                                            verbose_name='ID \u0437\u0430\u0434\u0430\u0447\u0438 \u0432 \u0443\u0447\u0435\u0431\u0435', blank=True)),
                ('screenshot', models.ImageField(upload_to=kelvin.problems.models.screenshot_upload_path,
                                                 null=True, verbose_name='\u0421\u043a\u0440\u0438\u043d\u0448\u043e\u0442', blank=True)),
                ('max_points', models.IntegerField(
                    default=20, verbose_name='\u041c\u0430\u043a\u0441\u0438\u043c\u0430\u043b\u044c\u043d\u044b\u0439 \u0431\u0430\u043b\u043b \u0437\u0430 \u0437\u0430\u0434\u0430\u0447\u0443', blank=True)),
                ('cover', models.ForeignKey(related_name='cover_for_problems',
                                            verbose_name='\u041e\u0431\u043b\u043e\u0436\u043a\u0430 \u0437\u0430\u0434\u0430\u0447\u0438', blank=True, to='resources.Resource', null=True)),
                ('meta', models.ForeignKey(verbose_name='\u041c\u0435\u0442\u0430\u0438\u043d\u0444\u043e\u0440\u043c\u0430\u0446\u0438\u044f \u043e \u0437\u0430\u0434\u0430\u0447\u0435',
                                           blank=True, to='problem_meta.ProblemMeta', null=True)),
                ('owner', models.ForeignKey(
                    verbose_name='\u0410\u0432\u0442\u043e\u0440 \u0437\u0430\u0434\u0430\u0447\u0438', to=settings.AUTH_USER_MODEL)),
                ('resources', models.ManyToManyField(to='resources.Resource',
                                                     verbose_name='\u0420\u0435\u0441\u0443\u0440\u0441\u044b, \u0438\u0441\u043f\u043e\u043b\u044c\u0437\u0443\u0435\u043c\u044b\u0435 \u0432 \u0437\u0430\u0434\u0430\u0447\u0435', blank=True)),
                ('subject', models.ForeignKey(
                    verbose_name='\u0423\u0447\u0435\u0431\u043d\u044b\u0439 \u043f\u0440\u0435\u0434\u043c\u0435\u0442 \u0437\u0430\u0434\u0430\u0447\u0438', to='subjects.Subject')),
            ],
            options={
                'verbose_name': '\u0417\u0430\u0434\u0430\u0447\u0430',
                'verbose_name_plural': '\u0417\u0430\u0434\u0430\u0447\u0438',
            },
        ),
        migrations.CreateModel(
            name='ProblemHistory',
            fields=[
                ('id', models.AutoField(verbose_name='ID', serialize=False, auto_created=True, primary_key=True)),
                ('date_created', models.DateTimeField(auto_now_add=True, verbose_name='Creation date')),
                ('date_updated', models.DateTimeField(auto_now=True, verbose_name='Date of change')),
                ('markup', jsonfield.fields.JSONField(
                    verbose_name='\u0420\u0430\u0437\u043c\u0435\u0442\u043a\u0430 \u0437\u0430\u0434\u0430\u0447\u0438')),
                ('old_markup', jsonfield.fields.JSONField(
                    null=True, verbose_name='\u0423\u0441\u0442\u0430\u0440\u0435\u0432\u0448\u0430\u044f \u0440\u0430\u0437\u043c\u0435\u0442\u043a\u0430 \u0437\u0430\u0434\u0430\u0447\u0438', blank=True)),
                ('message', models.CharField(max_length=128,
                                             verbose_name='\u0421\u043e\u043e\u0431\u0449\u0435\u043d\u0438\u0435', blank=True)),
                ('author', models.ForeignKey(verbose_name='\u0410\u0432\u0442\u043e\u0440 \u0432\u0435\u0440\u0441\u0438\u0438',
                                             blank=True, to=settings.AUTH_USER_MODEL, null=True)),
                ('problem', models.ForeignKey(verbose_name='\u0417\u0430\u0434\u0430\u0447\u0430', to='problems.Problem')),
            ],
            options={
                'verbose_name': '\u0412\u0435\u0440\u0441\u0438\u044f \u0440\u0430\u0437\u043c\u0435\u0442\u043a\u0438 \u0437\u0430\u0434\u0430\u0447\u0438',
                'verbose_name_plural': '\u0412\u0435\u0440\u0441\u0438\u0438 \u0440\u0430\u0437\u043c\u0435\u0442\u043e\u043a \u0437\u0430\u0434\u0430\u0447',
            },
        ),
        migrations.CreateModel(
            name='TextResource',
            fields=[
                ('id', models.AutoField(verbose_name='ID', serialize=False, auto_created=True, primary_key=True)),
                ('date_created', models.DateTimeField(auto_now_add=True, verbose_name='Creation date')),
                ('date_updated', models.DateTimeField(auto_now=True, verbose_name='Date of change')),
                ('name', models.CharField(max_length=255,
                                          verbose_name='\u041d\u0430\u0437\u0432\u0430\u043d\u0438\u0435 \u043c\u0430\u0442\u0435\u0440\u0438\u0430\u043b\u0430')),
                ('content', models.TextField(
                    verbose_name='\u0421\u043e\u0434\u0435\u0440\u0436\u0438\u043c\u043e\u0435 \u043c\u0430\u0442\u0435\u0440\u0438\u0430\u043b\u0430', blank=True)),
                ('content_type', models.IntegerField(default=5, verbose_name='\u0422\u0438\u043f \u0441\u043e\u0434\u0435\u0440\u0436\u0438\u043c\u043e\u0433\u043e', choices=[(1, '\u041e\u043f\u0440\u0435\u0434\u0435\u043b\u0435\u043d\u0438\u0435'), (2, '\u041f\u0440\u0438\u043c\u0435\u0440'), (3, '\u041f\u0440\u0430\u0432\u0438\u043b\u043e'), (
                    4, '\u0422\u0435\u043e\u0440\u0435\u043c\u0430'), (5, '\u0422\u0435\u043a\u0441\u0442'), (6, '\u041c\u0435\u0442\u043e\u0434\u0438\u0447\u0435\u0441\u043a\u0438\u0435 \u043c\u0430\u0442\u0435\u0440\u0438\u0430\u043b\u044b'), (7, '\u0412\u0438\u0434\u0435\u043e'), (8, '\u0422\u0435\u043e\u0440\u0438\u044f')])),
                ('formulas', jsonfield.fields.JSONField(default={},
                                                        verbose_name='\u0424\u043e\u0440\u043c\u0443\u043b\u044b', blank=True)),
                ('owner', models.ForeignKey(
                    verbose_name='\u0410\u0432\u0442\u043e\u0440 \u043c\u0430\u0442\u0435\u0440\u0438\u0430\u043b\u0430', to=settings.AUTH_USER_MODEL)),
                ('resources', models.ManyToManyField(to='resources.Resource',
                                                     verbose_name='\u041f\u0440\u0438\u0432\u044f\u0437\u0430\u043d\u043d\u044b\u0435 \u0440\u0435\u0441\u0443\u0440\u0441\u044b', blank=True)),
                ('subject', models.ForeignKey(verbose_name='\u041f\u0440\u0435\u0434\u043c\u0435\u0442',
                                              blank=True, to='subjects.Subject', null=True)),
                ('themes', models.ManyToManyField(to='subjects.Theme',
                                                  verbose_name='\u041f\u0440\u0438\u0432\u044f\u0437\u0430\u043d\u043d\u044b\u0435 \u0442\u0435\u043c\u044b', blank=True)),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.AddField(
            model_name='problem',
            name='tips',
            field=sortedm2m.fields.SortedManyToManyField(
                help_text=None, to='problems.TextResource', verbose_name='\u0428\u043f\u0430\u0440\u0433\u0430\u043b\u043a\u0438', blank=True),
        ),
    ]
