from django.db import migrations, models

from kelvin.problem_meta.models import ProblemMeta
from kelvin.problems.models import Problem


def change_max_points(apps, schema_editor):
    for difficulty, name in ProblemMeta.DIFFICULTIES:
        Problem.objects.filter(
            meta__difficulty=difficulty,
        ).update(
            max_points=Problem.DEFAULT_MAX_POINTS[difficulty],
        )


def reversed_change_max_points(apps, schema_editor):
    # Данная миграция не поддерживает откат
    pass


class Migration(migrations.Migration):

    dependencies = [
        ('problems', '0001_initial'),
    ]

    operations = [
        migrations.RunPython(change_max_points, reversed_change_max_points),
    ]
