from builtins import object

from kelvin.common.serializer_fields import NestedForeignKeyField
from kelvin.problems.models import Problem, TextResource
from kelvin.problems.serializers import (
    ProblemIdDateSerializer, ProblemSerializer, TextResourceIdDateSerializer, TextResourceSerializer,
)


class ExpandableProblemField(NestedForeignKeyField):
    """
    Сериализатор вопроса, который сериализует полностью вопрос лишь при
    наличии параметра в контексте
    """
    class Meta(object):
        serializer = ProblemSerializer
        model = Problem

    def to_representation(self, value):
        """
        Смотрим, разворачивать или нет задачи
        """
        if self.context.get('expand_problems'):
            return super(ExpandableProblemField, self).to_representation(value)
        else:
            return ProblemIdDateSerializer().to_representation(value)


class ExpandableTextResourceField(NestedForeignKeyField):
    """
    Сериализатор текстового ресурса, сериализует полностью лишь при наличии
    параметра в контексте
    """
    class Meta(object):
        serializer = TextResourceSerializer
        model = TextResource

    def to_representation(self, value):
        """
        Смотрим, разворачивать или нет ресурсы
        """
        if self.context.get('expand_problems'):
            return super(ExpandableTextResourceField,
                         self).to_representation(value)
        else:
            return TextResourceIdDateSerializer().to_representation(value)
