from builtins import str

from kelvin.problems.constants import LAYOUT_BLOCK_KIND_MARKER


def get_markers_from_layout(layout):
    """
    Достаёт маркеры из разметки
    """
    return (
        block['content'] for block in layout
        if block['kind'] == LAYOUT_BLOCK_KIND_MARKER
    )


def get_markers_dict_from_layout(layout):
    """
    Преобразует разметку в словарь вида {id_маркера: маркер}
    """
    return {
        str(marker['id']): marker
        for marker in get_markers_from_layout(layout)
    }
