from django.db import migrations, models
import jsonfield.fields


class Migration(migrations.Migration):

    dependencies = [
        ('subjects', '0001_initial'),
        ('courses', '0002_auto_20170804_1333'),
    ]

    operations = [
        migrations.CreateModel(
            name='Project',
            fields=[
                ('id', models.AutoField(verbose_name='ID', serialize=False, auto_created=True, primary_key=True)),
                ('date_created', models.DateTimeField(auto_now_add=True, verbose_name='Creation date')),
                ('date_updated', models.DateTimeField(auto_now=True, verbose_name='Date of change')),
                ('slug', models.SlugField(unique=True, max_length=255,
                                          verbose_name='\u0421\u043b\u0430\u0433-\u0438\u0434\u0435\u043d\u0442\u0438\u0444\u0438\u043a\u0430\u0442\u043e\u0440 \u043f\u0440\u043e\u0435\u043a\u0442\u0430')),
                ('title', models.CharField(max_length=255,
                                           verbose_name='\u041d\u0430\u0437\u0432\u0430\u043d\u0438\u0435 \u043f\u0440\u043e\u0435\u043a\u0442\u0430')),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='ProjectSubject',
            fields=[
                ('id', models.AutoField(verbose_name='ID', serialize=False, auto_created=True, primary_key=True)),
                ('date_created', models.DateTimeField(auto_now_add=True, verbose_name='Creation date')),
                ('date_updated', models.DateTimeField(auto_now=True, verbose_name='Date of change')),
                ('slug', models.CharField(help_text='\u0423\u043d\u0438\u043a\u0430\u043b\u044c\u043d\u044b\u0439 \u0441\u043b\u0430\u0433-\u0438\u0434\u0435\u043d\u0442\u0438\u0444\u0438\u043a\u0430\u0442\u043e\u0440 \u0432 \u0440\u0430\u043c\u043a\u0430\u0445 \u043e\u0434\u043d\u043e\u0433\u043e \u043f\u0440\u043e\u0435\u043a\u0442\u0430',
                                          max_length=255, verbose_name='\u0421\u043b\u0430\u0433-\u0438\u0434\u0435\u043d\u0442\u0438\u0444\u0438\u043a\u0430\u0442\u043e\u0440 \u041f\u0440\u043e\u0435\u043a\u0442\u043e\u041f\u0440\u0435\u0434\u043c\u0435\u0442\u0430')),
                ('title', models.CharField(max_length=255,
                                           verbose_name='\u041d\u0430\u0437\u0432\u0430\u043d\u0438\u0435 \u041f\u0440\u043e\u0435\u043a\u0442\u043e\u041f\u0440\u0435\u0434\u043c\u0435\u0442\u0430')),
                ('full_title', models.CharField(max_length=511, verbose_name='\u041f\u043e\u043b\u043d\u043e\u0435 \u043d\u0430\u0437\u0432\u0430\u043d\u0438\u0435 \u041f\u0440\u043e\u0435\u043a\u0442\u043e\u041f\u0440\u0435\u0434\u043c\u0435\u0442\u0430', blank=True)),
                ('order', models.PositiveIntegerField(
                    verbose_name='\u041f\u043e\u0440\u044f\u0434\u043e\u043a \u0441\u043e\u0440\u0442\u0438\u0440\u043e\u0432\u043a\u0438')),
                ('background', models.CharField(max_length=10,
                                                verbose_name='\u0424\u043e\u043d\u043e\u0432\u044b\u0439 \u0446\u0432\u0435\u0442')),
                ('meta', jsonfield.fields.JSONField(default={}, help_text='\u041e\u0431\u044a\u0435\u043a\u0442 \u0441 \u043c\u0435\u0442\u0430-\u0438\u043d\u0444\u043e\u0440\u043c\u0430\u0446\u0438\u0435\u0439 \u043e \u043f\u0440\u043e\u0435\u043a\u0442\u043e\u043f\u0440\u0435\u0434\u043c\u0435\u0442\u0435. \u041c\u043e\u0436\u0435\u0442 \u0441\u043e\u0434\u0435\u0440\u0436\u0430\u0442\u044c \u043f\u043e\u043b\u044f description, keywords \u0438 image.',
                                                    verbose_name='\u041c\u0435\u0442\u0430-\u0438\u043d\u0444\u043e\u0440\u043c\u0430\u0446\u0438\u044f \u043f\u0440\u043e\u0435\u043a\u0442\u043e\u043f\u0440\u0435\u0434\u043c\u0435\u0442\u0430', blank=True)),
                ('project', models.ForeignKey(related_name='subjects',
                                              verbose_name='\u041f\u0440\u043e\u0435\u043a\u0442', to='projects.Project')),
                ('subject', models.ForeignKey(verbose_name='\u041f\u0440\u0435\u0434\u043c\u0435\u0442', to='subjects.Subject', null=True)),
            ],
        ),
        migrations.CreateModel(
            name='ProjectSubjectItem',
            fields=[
                ('id', models.AutoField(verbose_name='ID', serialize=False, auto_created=True, primary_key=True)),
                ('date_created', models.DateTimeField(auto_now_add=True, verbose_name='Creation date')),
                ('date_updated', models.DateTimeField(auto_now=True, verbose_name='Date of change')),
                ('display_type', models.PositiveSmallIntegerField(default=1, verbose_name='\u0422\u0438\u043f \u043e\u0442\u043e\u0431\u0440\u0430\u0436\u0435\u043d\u0438\u044f \u044d\u043b\u0435\u043c\u0435\u043d\u0442\u0430', choices=[(1, '\u041a\u0430\u0440\u0442\u043e\u0447\u043a\u0430 1/4'), (
                    2, '\u041a\u0430\u0440\u0442\u043e\u0447\u043a\u0430 1/2'), (3, '\u0420\u0430\u0441\u0448\u0438\u0440\u0435\u043d\u043d\u0430\u044f \u043a\u0430\u0440\u0442\u043e\u0447\u043a\u0430 1/4'), (4, '\u0420\u0430\u0441\u0448\u0438\u0440\u0435\u043d\u043d\u0430\u044f \u043a\u0430\u0440\u0442\u043e\u0447\u043a\u0430 1/2')])),
                ('item_type', models.PositiveSmallIntegerField(
                    default=1, verbose_name='\u0422\u0438\u043f \u043a\u043e\u043d\u0442\u0435\u043d\u0442\u0430', choices=[(1, '\u041a\u0443\u0440\u0441')])),
                ('order', models.PositiveIntegerField(
                    verbose_name='\u041f\u043e\u0440\u044f\u0434\u043e\u043a \u0441\u043e\u0440\u0442\u0438\u0440\u043e\u0432\u043a\u0438')),
                ('display_options', jsonfield.fields.JSONField(default={
                }, verbose_name='\u041e\u043f\u0446\u0438\u0438 \u043e\u0442\u043e\u0431\u0440\u0430\u0436\u0435\u043d\u0438\u044f \u044d\u043b\u0435\u043c\u0435\u043d\u0442\u0430', blank=True)),
                ('course', models.ForeignKey(
                    verbose_name='\u0418\u0434\u0435\u043d\u0442\u0438\u0444\u0438\u043a\u0430\u0442\u043e\u0440 \u043a\u0443\u0440\u0441\u0430', to='courses.Course')),
                ('project_subject', models.ForeignKey(related_name='content_items',
                                                      verbose_name='\u041f\u0440\u043e\u0435\u043a\u0442\u043e\u041f\u0440\u0435\u0434\u043c\u0435\u0442', to='projects.ProjectSubject')),
            ],
        ),
        migrations.AddField(
            model_name='project',
            name='default_project_subject',
            field=models.ForeignKey(related_name='+', verbose_name='\u041f\u0440\u043e\u0435\u043a\u0442\u043e\u041f\u0440\u0435\u0434\u043c\u0435\u0442 \u043f\u043e \u0443\u043c\u043e\u043b\u0447\u0430\u043d\u0438\u044e',
                                    blank=True, to='projects.ProjectSubject', null=True),
        ),
        migrations.AlterUniqueTogether(
            name='projectsubjectitem',
            unique_together=set([('project_subject', 'order')]),
        ),
        migrations.AlterUniqueTogether(
            name='projectsubject',
            unique_together=set([('project', 'slug'), ('project', 'order')]),
        ),
    ]
