from urllib.parse import urljoin

from django.conf import settings

from kelvin.common.sender import SenderEmail

from .models import CourseReportRequest


class CourseReportRequestEmail(SenderEmail):
    template_name = 'yql_report_complete'

    def __init__(self, report: CourseReportRequest, **kwargs):
        variables = {
            'report_name': str(report.query.title),
            'report_created': report.created.strftime(settings.DATETIME_FORMAT),
            'report_url': urljoin(
                settings.FRONTEND_HOST,
                f'api/report-result-data/{report.id}/'
            ),
            'course_name': str(report.course.name),
        }
        super().__init__(report.user, variables, **kwargs)
