# -*- coding: utf-8 -*-
# Generated by Django 1.11.29 on 2020-05-14 01:03
from __future__ import unicode_literals

from django.conf import settings
from django.db import migrations, models
import django.db.models.deletion
import django.utils.timezone
import kelvin.common.fields
import kelvin.common.serializers
import kelvin.reports.models
import model_utils.fields


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        ('courses', '0045_auto_20200507_1206'),
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
    ]

    operations = [
        migrations.CreateModel(
            name='CourseReportRequest',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created', model_utils.fields.AutoCreatedField(default=django.utils.timezone.now, editable=False, verbose_name='created')),
                ('modified', model_utils.fields.AutoLastModifiedField(default=django.utils.timezone.now, editable=False, verbose_name='modified')),
                ('status', models.CharField(choices=[('IDLE', 'IDLE'), ('PENDING', 'PENDING'), ('RUNNING', 'RUNNING'), ('COMPLETED', 'COMPLETED'), ('ABORTING', 'ABORTING'), ('ABORTED', 'ABORTED'), ('ERROR', 'ERROR'), ('UNKNOWN', 'UNKNOWN')], default='IDLE', max_length=20, verbose_name='статус')),
                ('format', models.CharField(choices=[('CSV', 'CSV'), ('JSON', 'JSON'), ('TSV', 'TSV'), ('TSKV', 'TSKV'), ('YSON_TEXT', 'YSON_TEXT'), ('YSON_BINARY', 'YSON_BINARY'), ('XLSX', 'XLSX'), ('WIKI', 'WIKI')], max_length=20, verbose_name='формат')),
                ('parameters', kelvin.common.fields.JSONField(blank=True, default={}, encoder=kelvin.common.serializers.CustomDjangoJSONEncoder, verbose_name='параметры запроса')),
                ('notify_by_email', models.BooleanField(default=True, verbose_name='отправить уведомление о выполнении на почту')),
                ('is_archived', models.BooleanField(default=False, verbose_name='в архиве')),
                ('course', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='report_requests', to='courses.Course', verbose_name='курс')),
            ],
            options={
                'verbose_name': 'отчет по курсу',
                'verbose_name_plural': 'отчеты по курсам',
                'ordering': ('-created',),
            },
        ),
        migrations.CreateModel(
            name='Operation',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created', model_utils.fields.AutoCreatedField(default=django.utils.timezone.now, editable=False, verbose_name='created')),
                ('modified', model_utils.fields.AutoLastModifiedField(default=django.utils.timezone.now, editable=False, verbose_name='modified')),
                ('status', models.CharField(choices=[('IDLE', 'IDLE'), ('PENDING', 'PENDING'), ('RUNNING', 'RUNNING'), ('COMPLETED', 'COMPLETED'), ('ABORTING', 'ABORTING'), ('ABORTED', 'ABORTED'), ('ERROR', 'ERROR'), ('UNKNOWN', 'UNKNOWN')], default='IDLE', max_length=20, verbose_name='статус')),
                ('yql_operation_id', models.CharField(blank=True, editable=False, max_length=255, verbose_name='OperationID')),
                ('action', models.CharField(choices=[('SAVE', 'SAVE'), ('PARSE', 'PARSE'), ('COMPILE', 'COMPILE'), ('VALIDATE', 'VALIDATE'), ('OPTIMIZE', 'OPTIMIZE'), ('RUN', 'RUN'), ('ABORT', 'ABORT'), ('STOP', 'STOP'), ('RESUME', 'RESUME'), ('EXTRACT_PARAMS_META', 'EXTRACT_PARAMS_META')], default='RUN', max_length=20, verbose_name='действие')),
                ('query_data', kelvin.common.fields.JSONField(encoder=kelvin.common.serializers.CustomDjangoJSONEncoder, verbose_name='данные запроса')),
                ('query_title', models.CharField(blank=True, max_length=255, verbose_name='название запроса')),
                ('errors', kelvin.common.fields.JSONField(blank=True, default={}, encoder=kelvin.common.serializers.CustomDjangoJSONEncoder, verbose_name='ошибки')),
                ('issues', kelvin.common.fields.JSONField(blank=True, default={}, encoder=kelvin.common.serializers.CustomDjangoJSONEncoder, verbose_name='предупреждения')),
                ('created_by', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='operations_created_by', to=settings.AUTH_USER_MODEL, verbose_name='создал')),
            ],
            options={
                'verbose_name': 'операция с запросом',
                'verbose_name_plural': 'операции с запросами',
                'ordering': ('-created',),
            },
        ),
        migrations.CreateModel(
            name='Query',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created', model_utils.fields.AutoCreatedField(default=django.utils.timezone.now, editable=False, verbose_name='created')),
                ('modified', model_utils.fields.AutoLastModifiedField(default=django.utils.timezone.now, editable=False, verbose_name='modified')),
                ('type', models.CharField(choices=[('SQLv1', 'SQLv1')], default='SQLv1', max_length=20, verbose_name='тип запроса')),
                ('title', models.CharField(max_length=255, verbose_name='название')),
                ('content', models.TextField(verbose_name='тело запроса')),
                ('version', models.IntegerField(blank=True, null=True, verbose_name='версия')),
                ('is_active', models.BooleanField(default=True, verbose_name='активен')),
                ('created_by', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='queries_created_by', to=settings.AUTH_USER_MODEL, verbose_name='создал')),
            ],
            options={
                'verbose_name': 'YQL запрос',
                'verbose_name_plural': 'YQL запросы',
                'ordering': ('-created',),
            },
        ),
        migrations.CreateModel(
            name='QueryParameter',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('order', models.PositiveIntegerField(db_index=True, editable=False)),
                ('name', models.CharField(max_length=255, verbose_name='название')),
                ('type', models.CharField(choices=[('string', 'string'), ('number', 'number'), ('datetime', 'datetime'), ('boolean', 'boolean')], default='string', max_length=20, verbose_name='тип параметра')),
                ('label', models.CharField(max_length=255, verbose_name='заголовок')),
                ('help_text', models.TextField(blank=True, verbose_name='описание')),
                ('is_hidden', models.BooleanField(default=False, verbose_name='скрытый')),
                ('query', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='parameters', to='reports.Query', verbose_name='YQL запрос')),
            ],
            options={
                'verbose_name': 'параметр запроса',
                'verbose_name_plural': 'параметры запроса',
                'ordering': ('order',),
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='ResultData',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created', model_utils.fields.AutoCreatedField(default=django.utils.timezone.now, editable=False, verbose_name='created')),
                ('modified', model_utils.fields.AutoLastModifiedField(default=django.utils.timezone.now, editable=False, verbose_name='modified')),
                ('format', models.CharField(choices=[('CSV', 'CSV'), ('JSON', 'JSON'), ('TSV', 'TSV'), ('TSKV', 'TSKV'), ('YSON_TEXT', 'YSON_TEXT'), ('YSON_BINARY', 'YSON_BINARY'), ('XLSX', 'XLSX'), ('WIKI', 'WIKI')], max_length=20, verbose_name='формат')),
                ('file', models.FileField(blank=True, null=True, upload_to=kelvin.reports.models.ResultData.file_upload_path, verbose_name='файл')),
                ('access_count', models.IntegerField(default=0, verbose_name='кол-во скачиваний')),
                ('operation', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='results', to='reports.Operation', verbose_name='операция с запросом')),
            ],
            options={
                'verbose_name': 'данные по запросу',
                'verbose_name_plural': 'данные по запросам',
            },
        ),
        migrations.AddField(
            model_name='operation',
            name='query',
            field=models.ForeignKey(on_delete=django.db.models.deletion.PROTECT, related_name='operations', to='reports.Query', verbose_name='YQL запрос'),
        ),
        migrations.AddField(
            model_name='coursereportrequest',
            name='operation',
            field=models.ForeignKey(blank=True, editable=False, null=True, on_delete=django.db.models.deletion.PROTECT, related_name='course_report_requests', to='reports.Operation', verbose_name='операция выполнения'),
        ),
        migrations.AddField(
            model_name='coursereportrequest',
            name='query',
            field=models.ForeignKey(on_delete=django.db.models.deletion.PROTECT, related_name='course_report_requests', to='reports.Query', verbose_name='YQL запрос'),
        ),
        migrations.AddField(
            model_name='coursereportrequest',
            name='result_data',
            field=models.ForeignKey(blank=True, editable=False, null=True, on_delete=django.db.models.deletion.PROTECT, related_name='course_report_requests', to='reports.ResultData', verbose_name='результаты по запросу'),
        ),
        migrations.AddField(
            model_name='coursereportrequest',
            name='user',
            field=models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='course_report_requests', to=settings.AUTH_USER_MODEL, verbose_name='пользователь'),
        ),
    ]
