from rest_framework import serializers

from .models import CourseReportRequest, Query, QueryParameter, ResultData


class QueryParameterSerializer(serializers.ModelSerializer):
    class Meta:
        model = QueryParameter
        fields = (
            'name',
            'type',
            'label',
            'help_text',
            'default',
        )


class QuerySerializer(serializers.ModelSerializer):
    parameters = QueryParameterSerializer(source='active_parameters', many=True)

    class Meta:
        model = Query
        fields = (
            'id',
            'title',
            'version',
            'parameters',
            'created',
            'modified',
        )
        read_only_fields = fields


class CourseReportRequestCreateSerializer(serializers.ModelSerializer):
    query_id = serializers.PrimaryKeyRelatedField(
        source='query',
        queryset=Query.objects.active(),
    )
    parameters = serializers.DictField()

    class Meta:
        model = CourseReportRequest
        fields = (
            'query_id',
            'parameters',
            'format',
            'notify_by_email',
        )


class CourseReportRequestSerializer(serializers.ModelSerializer):
    parameters = serializers.JSONField(required=False)
    errors = serializers.JSONField()
    issues = serializers.JSONField()

    class Meta:
        model = CourseReportRequest
        fields = (
            'id',
            'query_id',
            'parameters',
            'format',
            'status',
            'errors',
            'issues',
            'has_result_data',
            'notify_by_email',
            'created',
            'modified',
        )
        read_only_fields = fields


class CourseReportResultsDataSerializer(serializers.ModelSerializer):
    class Meta:
        model = ResultData
        fields = (
            'format',
            'file',
            'size',
            'created',
        )
        read_only_fields = fields
