"""
Сохранение отчетов в S3 и генерация почтовых уведомлений
"""
from builtins import str

from django.conf import settings
from django.core.files.storage import default_storage

from kelvin.mail.controllers import SenderEmailController


def unicode_encoder(item, encoding='utf-8'):
    """Кодирует переданную строку в Unicode"""
    return str(item).encode(encoding)


def send_report(receivers, name, paths):
    """
    Рассылает уведомление со ссылками на сохраненные в ходе генерации
    отчета файлы
    """
    SenderEmailController.send_messages(
        receivers=receivers,
        template_code=settings.REPORTS_NOTIFICATION_TEMPLATE_ID,
        report_name=name,
        report_files=[{
            'path': path,
            'link': default_storage.url(path)
        } for path in paths],
    )
