from django.forms.models import ModelMultipleChoiceField


class SlimModelMultipleChoiceField(ModelMultipleChoiceField):
    """
    Поле, которое правильно взаимодействует с виджетом autocomplete,
    которому нужны только  уже выбранные значения, а не все из базы.
    """
    # Предотвращаем хождение в базу за всеми элементами
    _choices = ()

    def prepare_value(self, value):
        """Сохраняем все выбранные элементы"""
        result = \
            super(SlimModelMultipleChoiceField, self).prepare_value(value)
        self.choices = []
        if result is not None:
            for i, r in enumerate(result):
                self.choices.append((r, self.label_from_instance(value[i])))
        return result
