from django.db import migrations, models
import kelvin.resources.models


class Migration(migrations.Migration):

    dependencies = [
    ]

    operations = [
        migrations.CreateModel(
            name='EducationResource',
            fields=[
                ('id', models.AutoField(verbose_name='ID', serialize=False, auto_created=True, primary_key=True)),
                ('edu_link', models.CharField(max_length=512,
                                              verbose_name='\u0421\u0441\u044b\u043b\u043a\u0430 \u0432 \u0423\u0447\u0435\u0431\u0435')),
            ],
        ),
        migrations.CreateModel(
            name='Resource',
            fields=[
                ('id', models.AutoField(verbose_name='ID', serialize=False, auto_created=True, primary_key=True)),
                ('date_created', models.DateTimeField(auto_now_add=True, verbose_name='Creation date')),
                ('date_updated', models.DateTimeField(auto_now=True, verbose_name='Date of change')),
                ('uid', models.CharField(null=True, max_length=255, blank=True, unique=True,
                                         verbose_name='\u0418\u0434\u0435\u043d\u0442\u0438\u0444\u0438\u043a\u0430\u0442\u043e\u0440 \u0423\u0447\u0435\u0431\u043d\u0438\u043a\u0430', db_index=True)),
                ('name', models.CharField(default='', max_length=255,
                                          verbose_name='\u041d\u0430\u0437\u0432\u0430\u043d\u0438\u0435', blank=True)),
                ('confirmed', models.BooleanField(default=False,
                                                  verbose_name='\u041f\u043e\u0434\u0442\u0432\u0435\u0440\u0436\u0434\u0435\u043d\u043d\u044b\u0439')),
                ('file', models.FileField(db_index=True, upload_to=kelvin.resources.models.resource_upload_path, null=True,
                                          verbose_name='\u0424\u0430\u0439\u043b \u0440\u0435\u0441\u0443\u0440\u0441\u0430', blank=True)),
                ('image_width', models.PositiveIntegerField(
                    null=True, verbose_name='\u0428\u0438\u0440\u0438\u043d\u0430 \u0444\u0430\u0439\u043b\u0430-\u043a\u0430\u0440\u0442\u0438\u043d\u043a\u0438', blank=True)),
                ('image_height', models.PositiveIntegerField(
                    null=True, verbose_name='\u0412\u044b\u0441\u043e\u0442\u0430 \u0444\u0430\u0439\u043b\u0430-\u043a\u0430\u0440\u0442\u0438\u043d\u043a\u0438', blank=True)),
            ],
            options={
                'verbose_name': '\u0420\u0435\u0441\u0443\u0440\u0441',
                'verbose_name_plural': '\u0420\u0435\u0441\u0443\u0440\u0441\u044b',
            },
        ),
        migrations.CreateModel(
            name='ResourceTag',
            fields=[
                ('id', models.AutoField(verbose_name='ID', serialize=False, auto_created=True, primary_key=True)),
                ('name', models.CharField(max_length=255, verbose_name='\u0422\u044d\u0433')),
                ('dependent_tags', models.ManyToManyField(related_name='additional_for',
                                                          verbose_name='\u0417\u0430\u0432\u0438\u0441\u0438\u043c\u044b\u0435 \u0442\u0435\u0433\u0438', to='resources.ResourceTag', blank=True)),
            ],
            options={
                'verbose_name': '\u0422\u044d\u0433 \u0434\u043b\u044f \u0440\u0435\u0441\u0443\u0440\u0441\u043e\u0432',
                'verbose_name_plural': '\u0422\u044d\u0433\u0438 \u0434\u043b\u044f \u0440\u0435\u0441\u0443\u0440\u0441\u043e\u0432',
            },
        ),
        migrations.AddField(
            model_name='resource',
            name='tags',
            field=models.ManyToManyField(to='resources.ResourceTag',
                                         verbose_name='\u0422\u044d\u0433\u0438', blank=True),
        ),
        migrations.AddField(
            model_name='educationresource',
            name='resource',
            field=models.ForeignKey(
                verbose_name='\u0412 \u043a\u0430\u043a\u043e\u043c \u0440\u0435\u0441\u0443\u0440\u0441\u0435 \u0445\u0440\u0430\u043d\u0438\u0442\u0441\u044f', to='resources.Resource'),
        ),
    ]
