"""
Необходимо сделать устаревшими все ресурсы созданные ранее даты 2017-08-30.
"""
from django.utils import timezone
import datetime
import logging

from django.db import migrations


logger = logging.getLogger(__name__)


def make_old_resources_deprecated(apps, schema_editor):
    """
    У ресурсов, которые были созданы ранее определенной даты необходимо
    поставить голочку "Устарел" (EDUCATION-397).
    """
    deprecation_date = datetime.datetime(
        year=2017, month=8, day=30, tzinfo=timezone.utc,
    )
    Resource = apps.get_model('resources', 'Resource')

    count = Resource.objects.filter(date_created__lt=deprecation_date).update(
        deprecated=True
    )

    logger.info('Amount of deprecated resources: %d', count)


class Migration(migrations.Migration):

    dependencies = [
        ('resources', '0003_remove_resource_confirmed'),
    ]

    operations = [
        migrations.RunPython(make_old_resources_deprecated,
                             migrations.RunPython.noop),
    ]
