from django.db import models, transaction
from django.db.models.signals import pre_save
from django.dispatch import receiver

from kelvin.resources.models import Resource
from kelvin.resources.services import set_image_dimensions

from .models import ScormResource
from .tasks import prepare_scorm_task

pre_save.connect(set_image_dimensions, Resource)


@receiver(signal=models.signals.post_save, sender=ScormResource)
def scorm_post_save_handler(instance: ScormResource, **kwargs):
    if instance.status != ScormResource.SCORM_MODULE_STATUS_PENDING or not instance.file:
        return

    transaction.on_commit(lambda: prepare_scorm_task.delay(scorm_resource_id=instance.id))
