from rest_framework import viewsets
from rest_framework.permissions import SAFE_METHODS, IsAuthenticated

from kelvin.accounts.permissions import IsContentManager, IsStaff
from kelvin.resources.models import Resource, ResourceTag
from kelvin.resources.serializers import ResourceSerializerCorp as ResourceSerializer
from kelvin.resources.serializers import ResourceTagSerializer
from kelvin.switcher import get_feature_bool_option


class ResourceTagViewSet(viewsets.ReadOnlyModelViewSet):
    """
    Получения списка тэгов ресурсов и описания одного тэга
    """
    serializer_class = ResourceTagSerializer
    queryset = ResourceTag.objects.all()
    permission_classes = [IsStaff]


class ResourceViewSet(viewsets.ModelViewSet):
    """
    Retrieve, create, update and delete of resources
    """
    serializer_class = ResourceSerializer

    def get_queryset(self):
        queryset = Resource.objects.all()
        return (queryset.prefetch_related('tags')
                if self.request.method in SAFE_METHODS else queryset)

    def initialize_request(self, request, *args, **kwargs):
        """
        Allow read resources to all Authenticated
        """
        request = super(ResourceViewSet, self).initialize_request(
            request, *args, **kwargs)
        method = request.method.lower()
        if method == 'get':
            self.permission_classes = [IsAuthenticated]
        else:
            self.permission_classes = [
                IsAuthenticated,
                IsContentManager,
            ]
        return request
