from past.utils import old_div
from premailer import transform

from django.conf import settings
from django.core.mail import send_mail
from django.template.exceptions import TemplateDoesNotExist
from django.template.loader import render_to_string


def send_diagnostics_result_email(course, stat):
    """Отправить письмо о результатах диагностики пользователю"""
    email = stat.student.email
    if not email:
        return False

    try:
        # процент выполнения по логике
        logic_percent = stat.result[0].get('percent') or 0
    except IndexError:
        return False

    if course.group.level.name == u'1 класс':
        if logic_percent >= 60:
            course_slug = 'math1classA'
            course_code = 'MXMA0MSA'
        else:
            course_slug = 'math1classB'
            course_code = 'Y64ZYH08'
    elif course.group.level.name == u'2 класс':
        if logic_percent >= 60:
            course_slug = 'math2classA'
            course_code = 'CCMX6L4M'
        else:
            course_slug = 'math2classB'
            course_code = 'BTAURAGB'
    elif course.group.level.name == u'3 класс':
        course_slug = 'math3-4class'
        course_code = 'SA25TYYP'
    elif course.group.level.name == u'4 класс':
        course_slug = 'math3-4class'
        course_code = 'SA25TYYP'
    else:
        return False

    ctx = {
        'user': stat.student,
        'percent': (old_div(sum(item.get('percent') or 0 for item in stat.result),
                    len(stat.result))) if stat.result else 0,
        'result_url': (
            '{0}classroom/courses/{1}/diagnostics/?code={2}&utm_source=email&'
            'utm_campaign=diagnostics_result'
            .format(settings.FRONTEND_HOST, course.id, stat.uuid)
        ),
        'about_course_url': (
            '{0}pages/{1}/?utm_source=email&utm_campaign=diagnostics_result'
            .format(settings.FRONTEND_HOST, course_slug)
        ),
        'register_url': (
            '{0}register-to-course/?code={1}&utm_source=email&'
            'utm_campaign=diagnostics_result'
            .format(settings.FRONTEND_HOST, course_code)
        ),
    }
    try:
        text = transform(render_to_string(
            'result_stats/email/diagnostics_result_email.html',
            ctx,
        ))
    except TemplateDoesNotExist:
        return False
    send_mail(
        u'Сможет ли ваш ребенок работать в IT-компании?',
        None,
        settings.DEFAULT_FROM_EMAIL,
        [email],
        html_message=text,
    )
    return True
