from django.db import migrations, models
import jsonfield.fields
from django.conf import settings
import django.core.validators
import uuid


class Migration(migrations.Migration):

    dependencies = [
        ('problems', '0001_initial'),
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
        ('courses', '0001_initial'),
    ]

    operations = [
        migrations.CreateModel(
            name='CourseLessonStat',
            fields=[
                ('id', models.AutoField(verbose_name='ID', serialize=False, auto_created=True, primary_key=True)),
                ('percent_complete', models.IntegerField(default=0, verbose_name='\u041f\u0440\u043e\u0446\u0435\u043d\u0442 \u0432\u044b\u043f\u043e\u043b\u043d\u0435\u043d\u0438\u044f \u0437\u0430\u043d\u044f\u0442\u0438\u044f', validators=[django.core.validators.MinValueValidator(0), django.core.validators.MaxValueValidator(100)])),
                ('percent_fail', models.IntegerField(default=0, verbose_name='\u041f\u0440\u043e\u0446\u0435\u043d\u0442 \u043e\u0448\u0438\u0431\u043e\u043a', validators=[django.core.validators.MinValueValidator(0), django.core.validators.MaxValueValidator(100)])),
                ('results_count', models.IntegerField(default=0, verbose_name='\u0423\u0447\u0442\u0435\u043d\u043e \u0440\u0435\u0437\u0443\u043b\u044c\u0442\u0430\u0442\u043e\u0432')),
                ('max_results_count', models.IntegerField(default=0, verbose_name='\u0412\u043e\u0437\u043c\u043e\u0436\u043d\u043e\u0435 \u043a\u043e\u043b-\u0432\u043e \u0440\u0435\u0437\u0443\u043b\u044c\u0442\u0430\u0442\u043e\u0432')),
                ('average_points', models.FloatField(default=0, verbose_name='\u0421\u0440\u0435\u0434\u043d\u0435\u0435 \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0435 \u0431\u0430\u043b\u043b\u043e\u0432 \u0437\u0430 \u0437\u0430\u043d\u044f\u0442\u0438\u0435 \u043f\u043e \u0443\u0447\u0435\u043d\u0438\u043a\u0430\u043c')),
                ('average_max_points', models.FloatField(default=0, verbose_name='\u0421\u0440\u0435\u0434\u043d\u0438\u0439 \u043c\u0430\u043a\u0441\u0438\u043c\u0443\u043c \u0431\u0430\u043b\u043b\u043e\u0432 \u043f\u043e \u0443\u0447\u0435\u043d\u0438\u043a\u0430\u043c')),
                ('clesson', models.OneToOneField(verbose_name='\u0417\u0430\u043d\u044f\u0442\u0438\u0435 \u043a\u0443\u0440\u0441\u0430', to='courses.CourseLessonLink')),
            ],
            options={
                'verbose_name': '\u0421\u0442\u0430\u0442\u0438\u0441\u0442\u0438\u043a\u0430 \u043f\u0440\u043e\u0445\u043e\u0436\u0434\u0435\u043d\u0438\u044f \u0433\u0440\u0443\u043f\u043f\u043e\u0439 \u0437\u0430\u043d\u044f\u0442\u0438\u044f',
                'verbose_name_plural': '\u0421\u0442\u0430\u0442\u0438\u0441\u0442\u0438\u043a\u0438 \u043f\u0440\u043e\u0445\u043e\u0436\u0434\u0435\u043d\u0438\u044f \u0433\u0440\u0443\u043f\u043f\u0430\u043c\u0438 \u0437\u0430\u043d\u044f\u0442\u0438\u0439',
            },
        ),
        migrations.CreateModel(
            name='DiagnosticsStat',
            fields=[
                ('id', models.AutoField(verbose_name='ID', serialize=False, auto_created=True, primary_key=True)),
                ('date_created', models.DateTimeField(auto_now_add=True, verbose_name='Creation date')),
                ('date_updated', models.DateTimeField(auto_now=True, verbose_name='Date of change')),
                ('points', models.IntegerField(verbose_name='\u0427\u0438\u0441\u043b\u043e \u0431\u0430\u043b\u043b\u043e\u0432')),
                ('count', models.IntegerField(default=0, verbose_name='\u0427\u0438\u0441\u043b\u043e \u0443\u0447\u0435\u043d\u0438\u043a\u043e\u0432')),
                ('course', models.ForeignKey(verbose_name='\u041a\u0443\u0440\u0441 \u0434\u0438\u0430\u0433\u043d\u043e\u0441\u0442\u0438\u043a\u0438', to='courses.Course')),
            ],
            options={
                'verbose_name': '\u0421\u0442\u0430\u0442\u0438\u0441\u0442\u0438\u043a\u0430 \u0431\u0430\u043b\u043b\u043e\u0432 \u0432 \u0434\u0438\u0430\u0433\u043d\u043e\u0441\u0442\u0438\u043a\u0435',
                'verbose_name_plural': '\u0421\u0442\u0430\u0442\u0438\u0441\u0442\u0438\u043a\u0438 \u0431\u0430\u043b\u043b\u043e\u0432 \u0432 \u0434\u0438\u0430\u0433\u043d\u043e\u0441\u0442\u0438\u043a\u0430\u0445',
            },
        ),
        migrations.CreateModel(
            name='LessonDiagnosticStats',
            fields=[
                ('id', models.AutoField(verbose_name='ID', serialize=False, auto_created=True, primary_key=True)),
                ('date_created', models.DateTimeField(auto_now_add=True, verbose_name='Creation date')),
                ('date_updated', models.DateTimeField(auto_now=True, verbose_name='Date of change')),
                ('average', models.IntegerField(verbose_name='\u0421\u0440\u0435\u0434\u043d\u0438\u0439 \u043f\u0440\u043e\u0446\u0435\u043d\u0442')),
                ('clesson', models.ForeignKey(verbose_name='\u0417\u0430\u043d\u044f\u0442\u0438\u0435 \u0434\u0438\u0430\u0433\u043d\u043e\u0441\u0442\u0438\u043a\u0438', to='courses.CourseLessonLink', unique=True)),
            ],
            options={
                'verbose_name': '\u0421\u0442\u0430\u0442\u0438\u0441\u0442\u0438\u043a\u0430 \u043f\u043e \u0437\u0430\u043d\u044f\u0442\u0438\u044e \u0432 \u0434\u0438\u0430\u0433\u043d\u043e\u0441\u0442\u0438\u043a\u0435',
                'verbose_name_plural': '\u0421\u0442\u0430\u0442\u0438\u0441\u0442\u0438\u043a\u0438 \u043f\u043e \u0437\u0430\u043d\u044f\u0442\u0438\u044f\u043c \u0432 \u0434\u0438\u0430\u0433\u043d\u043e\u0441\u0442\u0438\u043a\u0430\u0445',
            },
        ),
        migrations.CreateModel(
            name='ProblemStat',
            fields=[
                ('id', models.AutoField(verbose_name='ID', serialize=False, auto_created=True, primary_key=True)),
                ('date_created', models.DateTimeField(auto_now_add=True, verbose_name='Creation date')),
                ('date_updated', models.DateTimeField(auto_now=True, verbose_name='Date of change')),
                ('correct_number', models.IntegerField(default=0, verbose_name='\u041a-\u0432\u043e \u0432\u0435\u0440\u043d\u044b\u0445 \u043e\u0442\u0432\u0435\u0442\u043e\u0432 \u043d\u0430 \u0437\u0430\u0434\u0430\u0447\u0443')),
                ('incorrect_number', models.IntegerField(default=0, verbose_name='\u041a-\u0432\u043e \u043d\u0435\u0432\u0435\u0440\u043d\u044b\u0445 \u043e\u0442\u0432\u0435\u0442\u043e\u0432 \u043d\u0430 \u0437\u0430\u0434\u0430\u0447\u0443')),
                ('correct_percent', models.IntegerField(default=0, verbose_name='\u041f\u0440\u043e\u0446\u0435\u043d\u0442 \u0432\u0435\u0440\u043d\u044b\u0445 \u043e\u0442\u0432\u0435\u0442\u043e\u0432', validators=[django.core.validators.MinValueValidator(0), django.core.validators.MaxValueValidator(100)])),
                ('marker_stats', jsonfield.fields.JSONField(verbose_name='\u0414\u0435\u0442\u0430\u043b\u044c\u043d\u0430\u044f \u0441\u0442\u0430\u0442\u0438\u0441\u0442\u0438\u043a\u0430 \u043f\u043e \u043c\u0430\u0440\u043a\u0435\u0440\u0430\u043c')),
                ('problem', models.OneToOneField(verbose_name='\u0417\u0430\u0434\u0430\u0447\u0430', to='problems.Problem')),
            ],
            options={
                'verbose_name': '\u0421\u0442\u0430\u0442\u0438\u0441\u0442\u0438\u043a\u0430 \u043e\u0442\u0432\u0435\u0442\u043e\u0432 \u043f\u043e \u0437\u0430\u0434\u0430\u0447\u0435',
                'verbose_name_plural': '\u0421\u0442\u0430\u0442\u0438\u0441\u0442\u0438\u043a\u0438 \u043e\u0442\u0432\u0435\u0442\u043e\u0432 \u043f\u043e \u0437\u0430\u0434\u0430\u0447\u0430\u043c',
            },
        ),
        migrations.CreateModel(
            name='StudentCourseStat',
            fields=[
                ('id', models.AutoField(verbose_name='ID', serialize=False, auto_created=True, primary_key=True)),
                ('points', models.IntegerField(default=0, verbose_name='\u041e\u0447\u043a\u0438')),
                ('problems_correct', models.IntegerField(default=0, verbose_name='\u041a\u043e\u043b\u0438\u0447\u0435\u0441\u0442\u0432\u043e \u0432\u0435\u0440\u043d\u043e \u0440\u0435\u0448\u0435\u043d\u043d\u044b\u0445 \u0437\u0430\u0434\u0430\u0447')),
                ('problems_incorrect', models.IntegerField(default=0, verbose_name='\u041a\u043e\u043b\u0438\u0447\u0435\u0441\u0442\u0432\u043e \u043d\u0435\u0432\u0435\u0440\u043d\u043e \u0440\u0435\u0448\u0435\u043d\u043d\u044b\u0445 \u0437\u0430\u0434\u0430\u0447')),
                ('problems_skipped', models.IntegerField(default=0, verbose_name='\u041a\u043e\u043b\u0438\u0447\u0435\u0441\u0442\u0432\u043e \u043f\u0440\u043e\u043f\u0443\u0449\u0435\u043d\u043d\u044b\u0445 \u0437\u0430\u0434\u0430\u0447')),
                ('total_efficiency', models.IntegerField(default=0, verbose_name='\u042d\u0444\u0444\u0435\u043a\u0442\u0438\u0432\u043d\u043e\u0441\u0442\u044c \u043f\u043e \u0432\u0441\u0435\u043c \u0437\u0430\u043d\u044f\u0442\u0438\u044f\u043c', validators=[django.core.validators.MinValueValidator(0), django.core.validators.MaxValueValidator(100)])),
                ('clesson_data', jsonfield.fields.JSONField(verbose_name='\u0414\u0435\u0442\u0430\u043b\u0438\u0437\u0430\u0446\u0438\u044f \u043f\u043e \u0437\u0430\u043d\u044f\u0442\u0438\u044f\u043c')),
                ('trainer_last_level', models.IntegerField(default=0, verbose_name='\u041f\u043e\u0441\u043b\u0435\u0434\u043d\u0438\u0439 \u043f\u0440\u043e\u0439\u0434\u0435\u043d\u043d\u044b\u0439 \u0443\u0440\u043e\u0432\u0435\u043d\u044c \u0442\u0440\u0435\u043d\u0430\u0436\u0435\u0440\u0430')),
                ('course', models.ForeignKey(verbose_name='\u041a\u0443\u0440\u0441', to='courses.Course')),
                ('student', models.ForeignKey(verbose_name='\u0423\u0447\u0435\u043d\u0438\u043a', to=settings.AUTH_USER_MODEL)),
            ],
            options={
                'verbose_name': '\u0421\u0442\u0430\u0442\u0438\u0441\u0442\u0438\u043a\u0430 \u0443\u0447\u0435\u043d\u0438\u043a\u0430 \u043f\u043e \u043a\u0443\u0440\u0441\u0443',
                'verbose_name_plural': '\u0421\u0442\u0430\u0442\u0438\u0441\u0442\u0438\u043a\u0430 \u0443\u0447\u0435\u043d\u0438\u043a\u043e\u0432 \u043f\u043e \u043a\u0443\u0440\u0441\u0430\u043c',
            },
        ),
        migrations.CreateModel(
            name='StudentDiagnosticsStat',
            fields=[
                ('id', models.AutoField(verbose_name='ID', serialize=False, auto_created=True, primary_key=True)),
                ('date_created', models.DateTimeField(auto_now_add=True, verbose_name='Creation date')),
                ('date_updated', models.DateTimeField(auto_now=True, verbose_name='Date of change')),
                ('percent', models.IntegerField(null=True, verbose_name='\u041f\u0440\u043e\u0446\u0435\u043d\u0442\u0438\u043b\u044c \u0431\u0430\u043b\u043b\u043e\u0432 \u0443\u0447\u0435\u043d\u0438\u043a\u0430 \u0441\u0440\u0435\u0434\u0438 \u0432\u0441\u0435\u0445 \u0443\u0447\u0435\u043d\u0438\u043a\u043e\u0432', blank=True)),
                ('result', jsonfield.fields.JSONField(null=True, verbose_name='\u0420\u0435\u0437\u0443\u043b\u044c\u0442\u0430\u0442\u044b \u0443\u0447\u0435\u043d\u0438\u043a\u0430 \u043f\u043e \u043a\u0430\u0436\u0434\u043e\u043c\u0443 \u0437\u0430\u043d\u044f\u0442\u0438\u044e', blank=True)),
                ('calculated', models.BooleanField(default=False, verbose_name='\u0421\u0442\u0430\u0442\u0438\u0441\u0442\u0438\u043a\u0430 \u043f\u043e\u0441\u0447\u0438\u0442\u0430\u043d\u0430')),
                ('email_sent', models.BooleanField(default=False, verbose_name='\u0411\u042b\u043b\u043e \u043f\u043e\u0441\u043b\u0430\u043d\u043e \u043f\u0438\u0441\u044c\u043c\u043e \u043e \u0440\u0435\u0437\u0443\u043b\u044c\u0442\u0430\u0442\u0430\u0445 \u0434\u0438\u0430\u0433\u043d\u043e\u0441\u0442\u0438\u043a\u0438')),
                ('uuid', models.UUIDField(default=uuid.uuid4, verbose_name='\u041a\u043e\u0434 \u0434\u043b\u044f \u043e\u0431\u0449\u0435\u0434\u043e\u0441\u0442\u0443\u043f\u043d\u043e\u0439 \u0441\u0441\u044b\u043b\u043a\u0438', editable=False, db_index=True)),
                ('course', models.ForeignKey(verbose_name='\u041a\u0443\u0440\u0441 \u0434\u0438\u0430\u0433\u043d\u043e\u0441\u0442\u0438\u043a\u0438', to='courses.Course')),
                ('student', models.ForeignKey(verbose_name='\u0423\u0447\u0435\u043d\u0438\u043a', to=settings.AUTH_USER_MODEL)),
            ],
            options={
                'verbose_name': '\u0421\u0442\u0430\u0442\u0438\u0441\u0442\u0438\u043a\u0430 \u0443\u0447\u0435\u043d\u0438\u043a\u0430 \u043f\u043e \u0434\u0438\u0430\u0433\u043d\u043e\u0441\u0442\u0438\u043a\u0435',
                'verbose_name_plural': '\u0421\u0442\u0430\u0442\u0438\u0441\u0442\u0438\u043a\u0438 \u0443\u0447\u0435\u043d\u0438\u043a\u043e\u0432 \u043f\u043e \u0434\u0438\u0430\u0433\u043d\u043e\u0441\u0442\u0438\u043a\u0430\u043c',
            },
        ),
        migrations.AlterUniqueTogether(
            name='studentdiagnosticsstat',
            unique_together=set([('student', 'course')]),
        ),
        migrations.AlterUniqueTogether(
            name='studentcoursestat',
            unique_together=set([('student', 'course')]),
        ),
        migrations.AlterUniqueTogether(
            name='diagnosticsstat',
            unique_together=set([('course', 'points')]),
        ),
    ]
