from django.db.models.signals import post_save

from kelvin.result_stats.tasks import (
    calculate_course_journal, calculate_lesson_journal, recalculate_courselessonstat,
    recalculate_studentcoursestat_by_result,
)
from kelvin.results.models import CourseLessonResult


def recalculate_stat_by_courselessonresult(sender, instance, **kwargs):
    """
    Запускает пересчет статистики группы по курсозанятию после сохранения
    инстанса `CourseLessonResult`
    """
    recalculate_courselessonstat.delay(instance.summary.clesson_id)


def recalculate_studentcoursestat_by_courselessonresult(sender, instance,
                                                        **kwargs):
    """
    Запускает пересчет статистики ученика по курсу после сохранения
    инстанса `CourseLessonResult`
    """
    recalculate_studentcoursestat_by_result.delay(instance.id)


def calculate_course_journal_by_courselessonresult(sender, instance, **kwargs):
    """
    Запускает пересчет журнала CourseGroupJournal с дополнительными полями.
    (метод table)
    Выгружает табличку в csv файл и обновляет поле course.journal
    Удаляет предыдущий журнал
    Запускается только если учеников в курсе >=
    MIN_COURSE_CSV_STUDENTS
    """
    calculate_course_journal.delay(instance.summary.clesson.course_id)


def calculate_lesson_journal_by_courselessonresult(sender, instance, **kwargs):
    """
    Запускает пересчет журнала LessonJournal с дополнительными полями.
    (метод table)
    Выгружает табличку в csv файл и обновляет поле clesson.journal
    Удаляет предыдущий журнал
    Запускается только если учеников в clesson >= чем
    MIN_LESSON_CSV_STUDENTS
    """
    calculate_lesson_journal.delay(instance.summary.clesson_id)


post_save.connect(calculate_course_journal_by_courselessonresult,
                  CourseLessonResult)
post_save.connect(calculate_lesson_journal_by_courselessonresult,
                  CourseLessonResult)
post_save.connect(recalculate_stat_by_courselessonresult,
                  CourseLessonResult)
post_save.connect(recalculate_studentcoursestat_by_courselessonresult,
                  CourseLessonResult)
