import io
from builtins import str

import xlsxwriter

from kelvin.resources.models import Resource


def save_journal_table_to_model(table, model):
    """
    Сохраняет таблицу журнала в FileField journal
    переданной модели в csv формате
    """
    buffer = io.BytesIO()
    workbook = xlsxwriter.Workbook(buffer)
    worksheet = workbook.add_worksheet()
    for i, row in enumerate(table):
        worksheet.write_row(i, 0, [str(item) for item in row])
    workbook.close()
    buffer.seek(0)

    journal_resource = model.journal_resource or Resource.objects.create()
    journal_resource.file.save(
        "students-{name}_{id}.xlsx".format(
            name=type(model).__name__.lower(),
            id=model.pk,
        ),
        buffer,
        save=True,
    )
    buffer.close()

    if not model.journal_resource:
        journal_resource.save()  # Чтобы создалась короткая ссылка

    model.journal_resource = journal_resource
    model.save()
