from builtins import object

import django_filters

from django.contrib.auth import get_user_model

from kelvin.common.filters import precise_datetime_filter
from kelvin.results.models import CourseLessonResult, LessonResult

User = get_user_model()


class LessonResultFilter(django_filters.FilterSet):
    """
    Фильтр для результатов
    """
    lesson = django_filters.NumberFilter(field_name='summary__lesson')
    student = django_filters.NumberFilter(field_name='summary__student')
    date_updated = django_filters.Filter(method=precise_datetime_filter)

    class Meta(object):
        model = LessonResult
        fields = (
            'lesson',
            'student',
            'completed',
            'date_updated',
        )


class CourseLessonResultFilter(django_filters.FilterSet):
    """
    Фильтр для результатов в курсе
    """
    clesson = django_filters.NumberFilter(field_name='summary__clesson')
    student = django_filters.NumberFilter(field_name='summary__student')
    date_updated = django_filters.Filter(method=precise_datetime_filter)

    class Meta(object):
        model = CourseLessonResult
        fields = (
            'clesson',
            'student',
            'completed',
            'date_updated',
        )
