from django.db import migrations, models
import jsonfield.fields
from django.conf import settings


class Migration(migrations.Migration):

    dependencies = [
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
        ('lessons', '0001_initial'),
        ('courses', '0001_initial'),
    ]

    operations = [
        migrations.CreateModel(
            name='CourseLessonResult',
            fields=[
                ('id', models.AutoField(verbose_name='ID', serialize=False, auto_created=True, primary_key=True)),
                ('date_created', models.DateTimeField(auto_now_add=True, verbose_name='Creation date')),
                ('date_updated', models.DateTimeField(auto_now=True, verbose_name='Date of change')),
                ('answers', jsonfield.fields.JSONField(
                    verbose_name='\u041e\u0442\u0432\u0435\u0442\u044b \u043d\u0430 \u0437\u0430\u043d\u044f\u0442\u0438\u0435')),
                ('points', models.IntegerField(
                    null=True, verbose_name='\u041a\u043e\u043b\u0438\u0447\u0435\u0441\u0442\u0432\u043e \u0431\u0430\u043b\u043b\u043e\u0432 \u0437\u0430 \u0437\u0430\u043d\u044f\u0442\u0438\u0435', blank=True)),
                ('max_points', models.IntegerField(verbose_name='\u041c\u0430\u043a\u0441\u0438\u043c\u0430\u043b\u044c\u043d\u043e\u0435 \u043a\u043e\u043b\u0438\u0447\u0435\u0441\u0442\u0432\u043e \u0431\u0430\u043b\u043b\u043e\u0432 \u0437\u0430 \u0437\u0430\u043d\u044f\u0442\u0438\u0435')),
                ('spent_time', models.IntegerField(null=True, verbose_name='\u041a\u043e\u043b\u0438\u0447\u0435\u0441\u0442\u0432\u043e \u0441\u0435\u043a\u0443\u043d\u0434, \u043f\u043e\u0442\u0440\u0430\u0447\u0435\u043d\u043d\u043e\u0435 \u043d\u0430 \u0437\u0430\u043d\u044f\u0442\u0438\u0435', blank=True)),
                ('completed', models.BooleanField(
                    default=True, verbose_name='\u041f\u043e\u043f\u044b\u0442\u043a\u0430 \u0437\u0430\u0432\u0435\u0440\u0448\u0435\u043d\u0430')),
                ('work_out', models.BooleanField(default=False,
                                                 verbose_name='\u041f\u043e\u043f\u044b\u0442\u043a\u0430 "\u0432\u043d\u0435 \u0437\u0430\u043d\u044f\u0442\u0438\u044f"')),
            ],
            options={
                'verbose_name': '\u0420\u0435\u0437\u0443\u043b\u044c\u0442\u0430\u0442 \u0437\u0430\u043d\u044f\u0442\u0438\u044f \u0432 \u043a\u0443\u0440\u0441\u0435',
                'verbose_name_plural': '\u0420\u0435\u0437\u0443\u043b\u044c\u0442\u0430\u0442\u044b \u0437\u0430\u043d\u044f\u0442\u0438\u0439 \u0432 \u043a\u0443\u0440\u0441\u0435',
            },
        ),
        migrations.CreateModel(
            name='CourseLessonSummary',
            fields=[
                ('id', models.AutoField(verbose_name='ID', serialize=False, auto_created=True, primary_key=True)),
                ('date_created', models.DateTimeField(auto_now_add=True, verbose_name='Creation date')),
                ('date_updated', models.DateTimeField(auto_now=True, verbose_name='Date of change')),
                ('data', jsonfield.fields.JSONField(
                    null=True, verbose_name='\u0421\u0432\u043e\u0434\u043a\u0430 \u0440\u0435\u0437\u0443\u043b\u044c\u0442\u0430\u0442\u043e\u0432', blank=True)),
                ('lesson_finished', models.BooleanField(default=False,
                                                        verbose_name='\u0423\u0447\u0435\u043d\u0438\u043a \u0437\u0430\u0432\u0435\u0440\u0448\u0438\u043b \u0437\u0430\u043d\u044f\u0442\u0438\u0435 \u0432 \u043a\u043b\u0430\u0441\u0441\u0435')),
                ('clesson', models.ForeignKey(
                    verbose_name='\u041f\u0440\u043e\u0439\u0434\u0435\u043d\u043d\u043e\u0435 \u043a\u0443\u0440\u0441\u043e\u0437\u0430\u043d\u044f\u0442\u0438\u0435', to='courses.CourseLessonLink')),
                ('student', models.ForeignKey(verbose_name='\u0423\u0447\u0435\u043d\u0438\u043a, \u043f\u0440\u043e\u0448\u0435\u0434\u0448\u0438\u0439 \u0437\u0430\u043d\u044f\u0442\u0438\u0435',
                                              blank=True, to=settings.AUTH_USER_MODEL, null=True)),
            ],
            options={
                'verbose_name': '\u0421\u0432\u043e\u0434\u043a\u0430 \u0440\u0435\u0437\u0443\u043b\u044c\u0442\u0430\u0442\u043e\u0432 \u0437\u0430\u043d\u044f\u0442\u0438\u044f \u0432 \u043a\u0443\u0440\u0441\u0430',
                'verbose_name_plural': '\u0421\u0432\u043e\u0434\u043a\u0438 \u0440\u0435\u0437\u0443\u043b\u044c\u0442\u0430\u0442\u043e\u0432 \u0437\u0430\u043d\u044f\u0442\u0438\u0439 \u0432 \u043a\u0443\u0440\u0441\u0435',
            },
        ),
        migrations.CreateModel(
            name='LessonResult',
            fields=[
                ('id', models.AutoField(verbose_name='ID', serialize=False, auto_created=True, primary_key=True)),
                ('date_created', models.DateTimeField(auto_now_add=True, verbose_name='Creation date')),
                ('date_updated', models.DateTimeField(auto_now=True, verbose_name='Date of change')),
                ('answers', jsonfield.fields.JSONField(
                    verbose_name='\u041e\u0442\u0432\u0435\u0442\u044b \u043d\u0430 \u0437\u0430\u043d\u044f\u0442\u0438\u0435')),
                ('points', models.IntegerField(
                    null=True, verbose_name='\u041a\u043e\u043b\u0438\u0447\u0435\u0441\u0442\u0432\u043e \u0431\u0430\u043b\u043b\u043e\u0432 \u0437\u0430 \u0437\u0430\u043d\u044f\u0442\u0438\u0435', blank=True)),
                ('max_points', models.IntegerField(verbose_name='\u041c\u0430\u043a\u0441\u0438\u043c\u0430\u043b\u044c\u043d\u043e\u0435 \u043a\u043e\u043b\u0438\u0447\u0435\u0441\u0442\u0432\u043e \u0431\u0430\u043b\u043b\u043e\u0432 \u0437\u0430 \u0437\u0430\u043d\u044f\u0442\u0438\u0435')),
                ('spent_time', models.IntegerField(null=True, verbose_name='\u041a\u043e\u043b\u0438\u0447\u0435\u0441\u0442\u0432\u043e \u0441\u0435\u043a\u0443\u043d\u0434, \u043f\u043e\u0442\u0440\u0430\u0447\u0435\u043d\u043d\u043e\u0435 \u043d\u0430 \u0437\u0430\u043d\u044f\u0442\u0438\u0435', blank=True)),
                ('completed', models.BooleanField(
                    default=True, verbose_name='\u041f\u043e\u043f\u044b\u0442\u043a\u0430 \u0437\u0430\u0432\u0435\u0440\u0448\u0435\u043d\u0430')),
                ('work_out', models.BooleanField(default=False,
                                                 verbose_name='\u041f\u043e\u043f\u044b\u0442\u043a\u0430 "\u0432\u043d\u0435 \u0437\u0430\u043d\u044f\u0442\u0438\u044f"')),
            ],
            options={
                'verbose_name': '\u0420\u0435\u0437\u0443\u043b\u044c\u0442\u0430\u0442 \u0437\u0430\u043d\u044f\u0442\u0438\u044f (\u0432\u043d\u0435 \u043a\u0443\u0440\u0441\u0430)',
                'verbose_name_plural': '\u0420\u0435\u0437\u0443\u043b\u044c\u0442\u0430\u0442\u044b \u0437\u0430\u043d\u044f\u0442\u0438\u0439 (\u0432\u043d\u0435 \u043a\u0443\u0440\u0441\u0430)',
            },
        ),
        migrations.CreateModel(
            name='LessonSummary',
            fields=[
                ('id', models.AutoField(verbose_name='ID', serialize=False, auto_created=True, primary_key=True)),
                ('date_created', models.DateTimeField(auto_now_add=True, verbose_name='Creation date')),
                ('date_updated', models.DateTimeField(auto_now=True, verbose_name='Date of change')),
                ('data', jsonfield.fields.JSONField(
                    null=True, verbose_name='\u0421\u0432\u043e\u0434\u043a\u0430 \u0440\u0435\u0437\u0443\u043b\u044c\u0442\u0430\u0442\u043e\u0432', blank=True)),
                ('lesson_finished', models.BooleanField(default=False,
                                                        verbose_name='\u0423\u0447\u0435\u043d\u0438\u043a \u0437\u0430\u0432\u0435\u0440\u0448\u0438\u043b \u0437\u0430\u043d\u044f\u0442\u0438\u0435 \u0432 \u043a\u043b\u0430\u0441\u0441\u0435')),
                ('lesson', models.ForeignKey(
                    verbose_name='\u041f\u0440\u043e\u0439\u0434\u0435\u043d\u043d\u043e\u0435 \u0437\u0430\u043d\u044f\u0442\u0438\u0435', to='lessons.Lesson')),
                ('student', models.ForeignKey(verbose_name='\u0423\u0447\u0435\u043d\u0438\u043a, \u043f\u0440\u043e\u0448\u0435\u0434\u0448\u0438\u0439 \u0437\u0430\u043d\u044f\u0442\u0438\u0435',
                                              blank=True, to=settings.AUTH_USER_MODEL, null=True)),
            ],
            options={
                'verbose_name': '\u0421\u0432\u043e\u0434\u043a\u0430 \u0440\u0435\u0437\u0443\u043b\u044c\u0442\u0430\u0442\u043e\u0432 \u0437\u0430\u043d\u044f\u0442\u0438\u044f (\u0432\u043d\u0435 \u043a\u0443\u0440\u0441\u0430)',
                'verbose_name_plural': '\u0421\u0432\u043e\u0434\u043a\u0438 \u0440\u0435\u0437\u0443\u043b\u044c\u0442\u0430\u0442\u043e\u0432 \u0437\u0430\u043d\u044f\u0442\u0438\u0439 (\u0432\u043d\u0435 \u043a\u0443\u0440\u0441\u0430)',
            },
        ),
        migrations.AddField(
            model_name='lessonresult',
            name='summary',
            field=models.ForeignKey(
                verbose_name='\u0421\u0432\u043e\u0434\u043a\u0430 \u0440\u0435\u0437\u0443\u043b\u044c\u0442\u0430\u0442\u043e\u0432 \u0437\u0430\u043d\u044f\u0442\u0438\u044f', to='results.LessonSummary'),
        ),
        migrations.AddField(
            model_name='courselessonresult',
            name='summary',
            field=models.ForeignKey(
                verbose_name='\u0421\u0432\u043e\u0434\u043a\u0430 \u0440\u0435\u0437\u0443\u043b\u044c\u0442\u0430\u0442\u043e\u0432 \u0437\u0430\u043d\u044f\u0442\u0438\u044f', to='results.CourseLessonSummary'),
        ),
        migrations.AlterUniqueTogether(
            name='lessonsummary',
            unique_together=set([('student', 'lesson')]),
        ),
        migrations.AlterUniqueTogether(
            name='courselessonsummary',
            unique_together=set([('student', 'clesson')]),
        ),
    ]
