from rest_framework import permissions


class ObjectCourseForOwner(permissions.BasePermission):
    """
    Проверка того, что пользователь является владельцем курса для данного
    clesson_result
    """

    def has_object_permission(self, request, view, obj):
        return obj.summary.clesson.course.owner == request.user


class ObjectResultAuthor(permissions.BasePermission):
    """
    Проверка того, что пользователь является учеником, создавшим результат
    """

    def has_object_permission(self, request, view, obj):
        return request.user.id == obj.summary.student_id


class ObjectResultForAnonymous(permissions.BasePermission):
    """
    Проверка того, что результат по курсу для анонимных пользователей
    """

    def has_object_permission(self, request, view, obj):
        return (obj.summary.student_id is None and
                obj.summary.clesson.course.allow_anonymous)


class ObjectResultContainsProblem(permissions.BasePermission):
    """
    Проверка того, что problem_link_id уже содержится в ответе
    """

    def has_object_permission(self, request, view, obj):
        return (request.parser_context['kwargs']['problem_link_id']
                in obj.answers)


class ObjectResultContainsProblemAttempt(permissions.BasePermission):
    """
    Проверка того, что для problem_link_id есть хотя бы одна попытка
    """

    def has_object_permission(self, request, view, obj):
        return obj.answers[request.parser_context['kwargs']['problem_link_id']]
