"""
JSON-схемы для валидации данных.
"""
from builtins import object

import jsonschema

from django.core.exceptions import ValidationError
from django.utils.html import escape


class StudentViewedProblemsFieldSchema(object):
    JSON_SCHEMA = {
        "type": "object",
        "patternProperties": {
            "^[0-9]$": {"type": "boolean"},
        },
        "additionalProperties": False,
    }


def student_viewed_problems_validator(data):
    try:
        jsonschema.validate(
            data, StudentViewedProblemsFieldSchema.JSON_SCHEMA
        )
    except jsonschema.ValidationError as e:
        raise ValidationError(e.message)
