from django.contrib.auth import get_user_model
from django.db import transaction

from kelvin.courses.models import Criterion
from kelvin.results.models import CourseLessonResult

User = get_user_model()


@transaction.atomic()
def pull_triggers(course_lesson_result: CourseLessonResult, force: bool = False):
    user = User.objects.filter(id=course_lesson_result.summary.student_id).first()
    if user:
        criteria = Criterion.objects.filter(
            assignment_rule__course_id=course_lesson_result.summary.clesson.course_id,
        )
        for criterion in criteria:
            criterion.do_actions(user=user, force=force)
